package cn.crushes.cloud.core.pay.wechat.v3.model.busifavor;

import lombok.Data;

/**
 * 修改商家券批次预算API请求参数
 *
 * @author youta
 */
@Data
public class BusiFavorBudgetParams {

    /**
     * 批次号
     */
    private String stockId;
    /**
     * 目标批次最大发放个数，同{@link #targetMaxCouponsByDay}二选一
     */
    private Integer targetMaxCoupons;
    /**
     * 目标单天发放上限个数，同{@link #targetMaxCoupons}二选一
     */
    private Integer targetMaxCouponsByDay;
    /**
     * 当前批次最大发放个数，当传入{@link #targetMaxCoupons}大于0时，必传
     */
    private Integer currentMaxCoupons;
    /**
     * 当前单天发放上限个数 ，当传入{@link #targetMaxCouponsByDay}大于0时，必填
     */
    private Integer currentMaxCouponsByDay;
    /**
     * 修改预算请求单据号
     */
    private String modifyBudgetRequestNo;
}
