package cn.crushes.cloud.core.pay.wechat.v3.model.batchtransfer;

import cn.crushes.cloud.core.pay.wechat.enumeration.DetailStatus;
import lombok.Data;

/**
 * 微信批次单号查询批次单API 或者 商家批次单号查询批次单API 请求参数
 *
 * @author youta
 */
@Data
public class QueryBatchTransferParams {
    /**
     * 微信批次单号 或 商家批次单号
     */
    private String code;
    /**
     * 是否查询转账明细单
     */
    private Boolean needQueryDetail;
    /**
     * 请求资源起始位置
     */
    private Integer offset;
    /**
     * 最大资源条数
     */
    private Integer limit;
    /**
     * 明细状态
     */
    private DetailStatus detailStatus;

}
