package cn.crushes.cloud.core.pay.wechat.v3.model;

import cn.crushes.cloud.core.pay.wechat.v2.model.allocation.Receiver;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 微信支付分账通知参数
 *
 * @author youta
 */
@Data
public class ProfitSharingConsumeData {

    /**
     * 直连商户号.
     * <p>
     * 直连模式分账发起和出资商户
     */
    private String mchid;

    /**
     * 微信订单号.
     * <p>
     * 微信支付订单号
     */
    private String transactionId;

    /**
     * 微信分账/回退单号.
     */
    private String orderId;

    /**
     * 商户分账/回退单号.
     * <p>
     * 分账方系统内部的分账/回退单号
     */
    private String outOrderNo;

    /**
     * 分账接收方.
     * <p>
     * 分账接收方对象
     */
    private Receiver receiver;

    /**
     * 成功时间.
     * <p>
     * Rfc3339标准
     */
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ssXXX", timezone = "GMT+8")
    private LocalDateTime successTime;

}
