package cn.crushes.cloud.core.pay.wechat.v3.model;

import lombok.Data;

/**
 * H5 信息
 *
 * @author youta
 */
@Data
public class H5Info {
    /**
     * 场景类型
     */
    private H5SceneType type;
    /**
     * 应用名称
     */
    private String appName;
    /**
     * 网站URL
     */
    private String appUrl;
    /**
     * IOS 平台 BundleID
     */
    private String bundleId;
    /**
     * Android 平台 PackageName
     */
    private String packageName;

    /**
     * H5 场景类型
     * @author youta
     */
    public enum H5SceneType {

        /**
         * IOS
         */
        iOS,
        /**
         * Android
         */
        Android,
        /**
         * Wap
         */
        Wap
    }
}
