package cn.crushes.cloud.core.pay.wechat.v3.model;

import cn.crushes.cloud.core.pay.wechat.enumeration.FundFlowAccountType;
import cn.crushes.cloud.core.pay.wechat.enumeration.TarType;
import lombok.Data;

import java.time.LocalDate;

/**
 * 申请资金账单请求参数
 *
 * @author youta
 */
@Data
public class FundFlowBillParams {
    /**
     * 账单日期，必传。
     * <p>
     * 格式YYYY-MM-DD，仅支持三个月内的账单下载申请。
     */
    private LocalDate billDate;
    /**
     * 资金账户类型,不填则默认值为{@link FundFlowAccountType#BASIC}
     *
     * @see FundFlowAccountType
     */
    private FundFlowAccountType accountType;
    /**
     * 压缩类型，不填默认值为数据流
     *
     * @see TarType
     */
    private TarType tarType;
}
