package cn.crushes.cloud.core.pay.wechat.v2;

import cn.crushes.cloud.core.pay.wechat.WechatPayProperties;
import cn.crushes.cloud.core.pay.wechat.v2.model.BaseModel;
import cn.crushes.cloud.core.pay.wechat.v3.WechatMetaBean;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.http.HttpMethod;

/**
 * 微信支付V2 客户端
 * <p>
 * V3接口不完善的临时性解决方案
 *
 * @author youta
 */
public class WechatV2Client {
    private final WechatMetaBean wechatMetaBean;

    public WechatV2Client(WechatMetaBean wechatMetaBean) {
        this.wechatMetaBean = wechatMetaBean;
    }

    public <M extends BaseModel> JsonNode wechatPayRequest(M model, HttpMethod method, String url) {
        WechatPayProperties.V3 v3 = wechatMetaBean.getV3();
        return model
                .appSecret(v3.getAppSecret())
                .request(v3.getMchId(), method, url);
    }

    public WechatMetaBean getWechatMetaBean() {
        return wechatMetaBean;
    }
}
