package cn.crushes.cloud.core.pay.wechat.v2;

import cn.crushes.cloud.core.pay.wechat.WechatPayProperties;
import cn.crushes.cloud.core.pay.wechat.v2.model.GroupRedpackModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.RedPackInfoModel;
import cn.crushes.cloud.core.pay.wechat.v2.model.RedPackModel;
import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.http.HttpMethod;

/**
 * 现金红包
 *
 * @author youta
 */
public class WechatPayRedPackApi {
    private final WechatV2Client wechatV2Client;

    /**
     * Instantiates a new Wechat pay redPack api.
     *
     * @param wechatV2Client the wechat v 2 client
     */
    public WechatPayRedPackApi(WechatV2Client wechatV2Client) {
        this.wechatV2Client = wechatV2Client;
    }

    /**
     * 发放随机红包
     *
     * @param redPackModel the redPack model
     * @return the json node
     */
    public JsonNode sendRedPack(RedPackModel redPackModel) {

        WechatPayProperties.V3 v3 = wechatV2Client.getWechatMetaBean().getV3();
        redPackModel.setWxappid(v3.getAppId());
        redPackModel.setMchId(v3.getMchId());
        return wechatV2Client.wechatPayRequest(redPackModel,
                HttpMethod.POST,
                "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendredpack");
    }

    /**
     * 发放裂变红包
     *
     * @param groupRedPackModel the group redPack model
     * @return the json node
     */
    public JsonNode sendRedPack(GroupRedpackModel groupRedPackModel) {
        WechatPayProperties.V3 v3 = wechatV2Client.getWechatMetaBean().getV3();
        groupRedPackModel.setWxappid(v3.getAppId());
        groupRedPackModel.setMchId(v3.getMchId());
        return wechatV2Client.wechatPayRequest(groupRedPackModel,
                HttpMethod.POST,
                "https://api.mch.weixin.qq.com/mmpaymkttransfers/sendgroupredpack");
    }

    /**
     * 查询红包信息
     *
     * @param redPackInfoModel the redPack info model
     * @return the json node
     */
    public JsonNode redPackInfo(RedPackInfoModel redPackInfoModel) {
        WechatPayProperties.V3 v3 = wechatV2Client.getWechatMetaBean().getV3();
        redPackInfoModel.setAppid(v3.getAppId());
        redPackInfoModel.setMchId(v3.getMchId());
        return wechatV2Client.wechatPayRequest(redPackInfoModel,
                HttpMethod.POST,
                "https://api.mch.weixin.qq.com/mmpaymkttransfers/gethbinfo");
    }
}
