package cn.crushes.cloud.core.common.utils;

import cn.crushes.cloud.core.common.constants.Oauth2Constant;
import cn.crushes.cloud.core.common.context.ReactiveRequestContextHolder;
import cn.crushes.cloud.core.common.entity.LoginUser;
import cn.crushes.cloud.core.common.exception.TokenException;
import io.jsonwebtoken.Claims;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;


public class SecurityUtil {

    public static Mono<LoginUser> getCurrentUser() {
        return ReactiveRequestContextHolder.getRequest().flatMap(request ->
                Mono.just(getCurrentUser(request)));
    }

    public static LoginUser getCurrentUser(ServerHttpRequest request) {
        String token = getToken(request);
        Claims claims = getClaims(token);
        return getLoginUser(claims);
    }

    private static LoginUser getLoginUser(Claims claims) {
        LoginUser loginUser = new LoginUser();
        loginUser.setUserId(String.valueOf(claims.get(Oauth2Constant.USER_ID)));
        loginUser.setUsername((String) claims.get(Oauth2Constant.USER_NAME));
        loginUser.setRoleId(String.valueOf(claims.get(Oauth2Constant.ROLE_ID)));
        loginUser.setType(NumberUtil.stoi(String.valueOf(claims.get(Oauth2Constant.TYPE))));
        loginUser.setAuthorities(String.valueOf(claims.get(Oauth2Constant.AUTHORITIES)));
        return loginUser;
    }

    public static Claims getClaims(String token) {
        Claims claims = null;
        if (StringUtils.hasText(token)) {
            try {
                claims = TokenUtil.getClaims(token);
            } catch (Exception e) {
                throw new TokenException("Token has expired");
            }
        }
        return claims;
    }

    public static String getToken(ServerHttpRequest request) {
        String headerToken = getHeaderToken(request);
        if (!StringUtils.hasText(headerToken)) {
            throw new TokenException("No token information");
        }
        return StringUtils.hasText(headerToken) ? TokenUtil.getToken(headerToken) : "";
    }

    public static String getHeaderToken(ServerHttpRequest request) {
        return request.getHeaders().getFirst(Oauth2Constant.HEADER_TOKEN);
    }
}
