package cn.crushes.cloud.core.common.enums;

import lombok.Getter;

/**
 * 异常枚举
 *
 * @author youta
 */
@Getter
public enum ApiExceptionEnum implements EnumInterface {

    /**
     * api异常枚举
     */
    INVALID_PARAM(400, "无效参数 -> 参数[{0}] -> 原因[{1}]"),
    PARAM_ERROR(400, "参数错误"),
    ;

    ApiExceptionEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private final int code;

    private final String msg;

}
