package cn.crushes.cloud.core.cache.providers;

import cn.crushes.cloud.core.cache.ReactiveCacheProvider;
import cn.crushes.cloud.core.cache.model.CacheType;
import lombok.AllArgsConstructor;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

import java.time.Duration;
import java.util.Optional;

@AllArgsConstructor
@Component
public class SpringCacheableProvider implements ReactiveCacheProvider {

    private final CacheManager cacheManager;
    private static final String CACHE_NAME ="rcache";

    @Override
    public Mono<Object> lookup(Object request,String cachePrefix) {

        return getCache()
                .map(cache -> cache.get(request.toString()))
                .map(Cache.ValueWrapper::get)
                .map(Mono::justOrEmpty)
                .orElse(Mono.empty());
    }

    @Override
    public Mono<Boolean> save(Object request, Object response,String cachePrefix, Duration ttl) {
        getCache().ifPresent(cache -> cache.put(request.toString(), response));
        return Mono.just(true);
    }

    private Optional<Cache> getCache() {
        return Optional.ofNullable(cacheManager.getCache(CACHE_NAME));
    }

    public CacheType cacheType() {
        return CacheType.LOCAL;
    }
}
