package cn.crushes.cloud.core.cache.providers;

import cn.crushes.cloud.core.cache.ReactiveCacheProvider;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import reactor.core.publisher.Mono;

import java.time.Duration;

@Slf4j
@AllArgsConstructor
public class ReactiveRedisCacheProvider implements ReactiveCacheProvider {

    final ReactiveRedisTemplate<String, Object> redisTemplate;

    public Mono<Object> lookup(Object request,String cachePrefix) {
        return redisTemplate.opsForValue()
                .get(cachePrefix + "::" + request.toString());
    }

    public Mono<Boolean> save(Object request, Object response,String cachePrefix,Duration ttl) {
        return redisTemplate.opsForValue()
                .set(cachePrefix + "::" + request.toString(), response, ttl);
    }
}
