package cn.crushes.cloud.core.cache.manager;

import cn.crushes.cloud.core.cache.ReactiveCacheProvider;
import cn.crushes.cloud.core.cache.model.CacheType;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;

@Service
@AllArgsConstructor
public class ReactiveCacheManager {

    private final List<ReactiveCacheProvider> providers;

    public Optional<ReactiveCacheProvider> initialize(CacheType cacheType) {
        return this.providers.stream()
                .filter(provider -> provider.cacheType() == cacheType)
                .findAny();
    }

    public <T> Optional<T> apply(CacheType cacheType, Function<ReactiveCacheProvider, T> function) {
        return this.initialize(cacheType)
                .map(function);
    }
}
