/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.cache.providers;

import cn.crushes.cloud.core.cache.ReactiveCacheProvider;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import reactor.core.publisher.Mono;

public class ReactiveRedisCacheProvider
implements ReactiveCacheProvider {
    private static final Logger log = LoggerFactory.getLogger(ReactiveRedisCacheProvider.class);
    final ReactiveRedisTemplate<String, Object> redisTemplate;

    @Override
    public Mono<Object> lookup(Object request, String cachePrefix) {
        return this.redisTemplate.opsForValue().get((Object)(cachePrefix + "::" + request.toString()));
    }

    @Override
    public Mono<Boolean> save(Object request, Object response, String cachePrefix, Duration ttl) {
        return this.redisTemplate.opsForValue().set((Object)(cachePrefix + "::" + request.toString()), response, ttl);
    }

    public ReactiveRedisCacheProvider(ReactiveRedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

