/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.cache.manager;

import cn.crushes.cloud.core.cache.ReactiveCacheProvider;
import cn.crushes.cloud.core.cache.model.CacheType;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.stereotype.Service;

@Service
public class ReactiveCacheManager {
    private final List<ReactiveCacheProvider> providers;

    public Optional<ReactiveCacheProvider> initialize(CacheType cacheType) {
        return this.providers.stream().filter(provider -> provider.cacheType() == cacheType).findAny();
    }

    public <T> Optional<T> apply(CacheType cacheType, Function<ReactiveCacheProvider, T> function) {
        return this.initialize(cacheType).map(function);
    }

    public ReactiveCacheManager(List<ReactiveCacheProvider> providers) {
        this.providers = providers;
    }
}

