/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.cache.aspect;

import cn.crushes.cloud.core.cache.aspect.CacheService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Aspect
@Component
public class ReactiveCache {
    private static final Logger log = LoggerFactory.getLogger(ReactiveCache.class);
    final CacheService cacheService;

    public ReactiveCache(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Around(value="@annotation(cn.crushes.cloud.core.cache.annotations.CacheMono)")
    public Mono<?> cache(ProceedingJoinPoint joinPoint) {
        return this.cacheService.getOrCache(joinPoint);
    }
}

