/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.cache.aspect;

import cn.crushes.cloud.core.cache.annotations.CacheMono;
import cn.crushes.cloud.core.cache.manager.ReactiveCacheManager;
import cn.crushes.cloud.core.cache.model.CacheType;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class CacheService {
    private static final Logger log = LoggerFactory.getLogger(CacheService.class);
    private final ReactiveCacheManager reactiveCacheManager;

    public Mono<?> getOrCache(ProceedingJoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        CacheMono cacheMono = method.getAnnotation(CacheMono.class);
        CacheType cacheType = cacheMono.cacheType();
        long expire = cacheMono.expire();
        String key = cacheMono.key();
        ArrayList<Object> request = new ArrayList<Object>();
        Collections.addAll(request, joinPoint.getArgs());
        return Mono.just(request).flatMap(reqList -> this.lookup(request, key, cacheType)).switchIfEmpty(this.proceedAndSave(joinPoint, request, key, expire, cacheType));
    }

    private Mono<Object> lookup(List<Object> request, String cachePrefix, CacheType cacheType) {
        return this.reactiveCacheManager.apply(cacheType, provider -> provider.lookup(request, cachePrefix).name("reactive.cache.lookup").metrics().doOnSuccess(o -> log.debug("cache found: " + o)).timeout(Duration.ofMillis(300L), Mono.fromCallable(() -> {
            log.warn("Timeout on lookup cache {}", (Object)request);
            return Mono.empty();
        })).onErrorResume(throwable -> {
            log.warn("Error while lookup cache" + throwable.getMessage());
            return Mono.empty();
        })).orElseThrow(() -> new RuntimeException("Invalid cache type"));
    }

    private Mono<?> proceedAndSave(ProceedingJoinPoint joinPoint, List<Object> request, String cachePrefix, long expire, CacheType cacheType) {
        Mono result = (Mono)joinPoint.proceed();
        return this.reactiveCacheManager.apply(cacheType, provider -> result.doOnSuccess(response -> provider.save(request, response, cachePrefix, Duration.ofMillis(expire)).name("reactive.cache.lookup").metrics().doOnSuccess(o -> log.debug("cached result: {}", response)).timeout(Duration.ofMillis(300L), Mono.defer(() -> {
            log.warn("Timeout while caching the response {}", response);
            return Mono.empty();
        })).doOnError(throwable -> log.debug("Error while saving the response", throwable)).onErrorResume(throwable -> Mono.empty()).subscribe())).orElseThrow(() -> new RuntimeException("Invalid cache type"));
    }

    public CacheService(ReactiveCacheManager reactiveCacheManager) {
        this.reactiveCacheManager = reactiveCacheManager;
    }
}

