package cn.crushes.cloud.core.cache.annotations;

import cn.crushes.cloud.core.cache.model.CacheType;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
public @interface CacheMono {

    String key() default "$$undefined$$";
    /**
     * 缓存方式
     * @return {@link CacheType}
     */
    CacheType cacheType() default CacheType.REDIS;
    /**
     * 缓存过期时间，单位秒，默认24小时
     */
    long expire() default 24 * 3600 * 1000L;
}
