package cn.crushes.cloud.core.cache;

import cn.crushes.cloud.core.cache.model.CacheType;
import reactor.core.publisher.Mono;

import java.time.Duration;

public interface ReactiveCacheProvider {

    default CacheType cacheType() { return CacheType.REDIS;}

    Mono<Object> lookup(Object request,String cachePrefix);

    Mono<Boolean> save(Object request, Object response,String cachePrefix, Duration ttl);
}
