/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.auth.filter;

import cn.crushes.cloud.core.auth.props.TokenProperties;
import cn.crushes.cloud.core.common.utils.ResponseUtil;
import cn.crushes.cloud.core.common.utils.SecurityUtil;
import cn.crushes.cloud.core.common.utils.TokenUtil;
import io.jsonwebtoken.Claims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
public class PreAuthFilter
implements WebFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(PreAuthFilter.class);
    private final ReactiveRedisTemplate<String, Object> redisService;
    private final TokenProperties properties;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (!this.properties.getEnable().booleanValue()) {
            return chain.filter(exchange);
        }
        String path = exchange.getRequest().getURI().getPath();
        String requestUrl = exchange.getRequest().getURI().getRawPath();
        if (this.ignore(path) || this.ignore(requestUrl)) {
            return chain.filter(exchange);
        }
        ServerHttpResponse resp = exchange.getResponse();
        String headerToken = exchange.getRequest().getHeaders().getFirst("Mine-Auth");
        if (headerToken == null) {
            return this.unauthorized(resp, "\u6ca1\u6709\u643a\u5e26Token\u4fe1\u606f");
        }
        String token = TokenUtil.getToken((String)headerToken);
        Claims claims = SecurityUtil.getClaims((String)token);
        if (claims == null) {
            return this.unauthorized(resp, "token\u5df2\u8fc7\u671f\u6216\u9a8c\u8bc1\u4e0d\u6b63\u786e\uff01");
        }
        String userId = String.valueOf(claims.get((Object)"userId"));
        if (!StringUtils.hasText((String)userId)) {
            return this.unauthorized(resp, "\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        return this.redisService.hasKey((Object)("compulsory:reLogin:" + userId)).flatMap(aBoolean -> {
            if (aBoolean.booleanValue()) {
                return this.unauthorized(resp, "\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            }
            return chain.filter(exchange);
        });
    }

    private Mono<Void> unauthorized(ServerHttpResponse resp, String msg) {
        return ResponseUtil.webFluxResponseWriter((ServerHttpResponse)resp, (String)"application/json;charset=UTF-8", (HttpStatus)HttpStatus.UNAUTHORIZED, (Object)msg);
    }

    private boolean ignore(String path) {
        return this.properties.getIgnoreUrl().stream().map(url -> url.replace("/**", "")).anyMatch(path::startsWith);
    }

    public int getOrder() {
        return -200;
    }

    public PreAuthFilter(ReactiveRedisTemplate<String, Object> redisService, TokenProperties properties) {
        this.redisService = redisService;
        this.properties = properties;
    }
}

