/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.auth.aspect;

import cn.crushes.cloud.core.auth.annotation.PreAuth;
import cn.crushes.cloud.core.common.context.ReactiveRequestContextHolder;
import cn.crushes.cloud.core.common.entity.LoginUser;
import cn.crushes.cloud.core.common.exception.TokenException;
import cn.crushes.cloud.core.common.utils.SecurityUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@Aspect
@Component
public class PreAuthAspect {
    private static final Logger log = LoggerFactory.getLogger(PreAuthAspect.class);
    private static final String ALL_PERMISSION = "*:*:*";

    @Around(value="@annotation(cn.crushes.cloud.core.auth.annotation.PreAuth)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        PreAuth preAuth = method.getAnnotation(PreAuth.class);
        if (ObjectUtils.isEmpty((Object)preAuth)) {
            return point.proceed();
        }
        String perm = preAuth.hasPerm();
        if (!StringUtils.hasText((String)perm)) {
            return point.proceed();
        }
        Mono mono = (Mono)point.proceed();
        return ReactiveRequestContextHolder.getRequest().flatMap(request -> {
            LoginUser currentUser = SecurityUtil.getCurrentUser((ServerHttpRequest)request);
            if (currentUser.getUsername().equalsIgnoreCase("admin")) {
                return mono;
            }
            if (StringUtils.hasText((String)perm) && !this.hasPermissions(Arrays.stream(String.valueOf(currentUser.getAuthorities()).split(",")).collect(Collectors.toList()), perm)) {
                return Mono.error((Throwable)new TokenException("\u6743\u9650\u9a8c\u8bc1\u4e0d\u901a\u8fc7"));
            }
            return mono;
        });
    }

    private boolean hasPermissions(Collection<String> authorities, String permission) {
        return authorities.stream().filter(StringUtils::hasText).anyMatch(x -> ALL_PERMISSION.contains((CharSequence)x) || PatternMatchUtils.simpleMatch((String)permission, (String)x));
    }
}

