/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.util.exception;

import cn.creekmoon.excel.util.exception.CheckedExcelException;
import cn.creekmoon.excel.util.exception.ExcelUtilsExceptionHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionMsgManager {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionMsgManager.class);
    public static final String MSG_PREFIX = "[\u5931\u8d25!]";
    public static final String MSG_SUFFIX = "";
    public static List<ExcelUtilsExceptionHandler> excelUtilsExceptionHandlers = new ArrayList<ExcelUtilsExceptionHandler>();

    public static String getExceptionMsg(Exception unCatchException) {
        for (ExcelUtilsExceptionHandler excelUtilsExceptionHandler : excelUtilsExceptionHandlers) {
            String msg = excelUtilsExceptionHandler.customExceptionMessage(unCatchException);
            if (msg == null) continue;
            return MSG_PREFIX + msg.replace(MSG_PREFIX, MSG_SUFFIX).replace(MSG_SUFFIX, MSG_SUFFIX);
        }
        log.error("ExcelUtils\u7ec4\u4ef6\u9047\u5230\u65e0\u6cd5\u5904\u7406\u7684\u5f02\u5e38!", (Throwable)unCatchException);
        return "\u5bfc\u5165\u5f02\u5e38!\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!";
    }

    public static void addExceptionHandler(ExcelUtilsExceptionHandler handler) {
        excelUtilsExceptionHandlers.add(handler);
        excelUtilsExceptionHandlers.sort(Comparator.comparing(ExcelUtilsExceptionHandler::getOrder));
    }

    static {
        GlobalExceptionMsgManager.addExceptionHandler(new DirectMessageExceptionHandler(CheckedExcelException.class));
    }

    public static class DirectMessageExceptionHandler
    implements ExcelUtilsExceptionHandler {
        private Class customExceptionClass = null;

        public DirectMessageExceptionHandler(Class customExceptionClass) {
            this.customExceptionClass = customExceptionClass;
        }

        public DirectMessageExceptionHandler(String customExceptionClassName) {
            this.customExceptionClass = Class.forName(customExceptionClassName);
        }

        @Override
        public String customExceptionMessage(Exception unCatchException) {
            if (this.customExceptionClass.isInstance(unCatchException)) {
                return unCatchException.getMessage();
            }
            return null;
        }

        @Override
        public int getOrder() {
            return Integer.MAX_VALUE;
        }
    }
}

