/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.util;

import cn.creekmoon.excel.core.ExcelUtilsConfig;
import cn.creekmoon.excel.core.W.ExcelExport;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;
import org.springframework.util.ResourceUtils;

public class ExcelFileUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelFileUtils.class);
    private static volatile String applicationParentFilePath;
    private static final ThreadFactory threadFactory;
    private static final ScheduledThreadPoolExecutor threadPoolExecutor;

    public static String generateXlsxAbsoluteFilePath(String uniqueId) {
        return ExcelFileUtils.getCustomAbsoluteFilePath(uniqueId + ".xlsx");
    }

    public static String getCustomAbsoluteFilePath(String fileName) {
        return ExcelFileUtils.getApplicationParentFilePath() + File.separator + "temp_files" + File.separator + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void response(InputStream fileInputStream, String fileName, HttpServletResponse response) throws IOException {
        response.setContentType("application/octet-stream");
        fileName = URLEncoder.encode(fileName, StandardCharsets.UTF_8);
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
        try (ServletOutputStream out = response.getOutputStream();){
            int length;
            byte[] b = new byte[4096];
            while ((length = fileInputStream.read(b)) > 0) {
                out.write(b, 0, length);
            }
            out.flush();
        }
        finally {
            IoUtil.close((Closeable)fileInputStream);
        }
    }

    public static void response(File file, String fileName, HttpServletResponse response) throws IOException {
        ExcelFileUtils.response(file.getAbsolutePath(), fileName, response);
    }

    public static void response(String filePath, String fileName, HttpServletResponse response) throws IOException {
        try (BufferedInputStream inputStream = FileUtil.getInputStream((String)filePath);){
            ExcelFileUtils.response(inputStream, fileName, response);
        }
    }

    public static void cleanTempFileByPathDelay(File file) {
        ExcelFileUtils.cleanTempFileByPathDelay(file.getAbsolutePath());
    }

    public static void cleanTempFileByPathDelay(String filePath) {
        ExcelFileUtils.cleanTempFileByPathDelay(filePath, ExcelUtilsConfig.TEMP_FILE_LIFE_MINUTES);
    }

    public static void cleanTempFileByPathDelay(String filePath, Integer fileLifeMinutes) {
        threadPoolExecutor.schedule(() -> ExcelFileUtils.cleanTempFileByPathNow(filePath), fileLifeMinutes != null ? (long)fileLifeMinutes.intValue() : (long)ExcelUtilsConfig.TEMP_FILE_LIFE_MINUTES, TimeUnit.MINUTES);
    }

    public static void cleanTempFileByPathNow(String filePath) {
        try {
            if (!FileUtil.del((String)filePath)) {
                log.warn("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25! \u8def\u5f84:" + filePath);
            }
            log.debug("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u6210\u529f!\u8def\u5f84:" + filePath);
        }
        catch (Exception e) {
            log.warn("\u6e05\u7406\u4e34\u65f6\u6587\u4ef6\u5931\u8d25! \u8def\u5f84:" + filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String getApplicationParentFilePath() {
        if (applicationParentFilePath != null) return applicationParentFilePath;
        Class<ExcelExport> clazz = ExcelExport.class;
        synchronized (ExcelExport.class) {
            try {
                if (applicationParentFilePath != null) return applicationParentFilePath;
                applicationParentFilePath = new File(Paths.get(ResourceUtils.getURL((String)"classpath:").toURI()).toString()).getParentFile().getParentFile().getParent();
            }
            catch (FileNotFoundException e) {
                log.error("\u751f\u6210\u4e34\u65f6\u76ee\u5f55\u5931\u8d25! \u8bf7\u68c0\u67e5!");
            }
            return applicationParentFilePath;
        }
    }

    static {
        threadFactory = new CustomizableThreadFactory("excel-clean-thread");
        threadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }
}

