/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.util;

import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;

public class ExcelCellUtils {
    public static int excelColumnToIndex(String column) {
        int result = 0;
        for (int i = 0; i < column.length(); ++i) {
            char c = column.charAt(i);
            result = result * 26 + (c - 65 + 1);
        }
        return result - 1;
    }

    public static int excelCellToColumnIndex(String cell) {
        String column = cell.replaceAll("[^A-Za-z]", "");
        return ExcelCellUtils.excelColumnToIndex(column);
    }

    public static int excelCellToRowIndex(String cell) {
        String row = cell.replaceAll("[^0-9]", "");
        return Integer.parseInt(row) - 1;
    }

    public static String excelIndexToCell(Integer rowIndex, Integer colIndex) {
        int col = colIndex + 1;
        int row = rowIndex + 1;
        StringBuilder sb = new StringBuilder();
        while (col > 0) {
            int remainder = (col - 1) % 26;
            char c = (char)(65 + remainder);
            sb.insert(0, c);
            col = (col - 1) / 26;
        }
        sb.append(row);
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("excelCellToRowNumber(\"B28\") = " + ExcelCellUtils.excelCellToRowIndex("B28"));
        System.out.println("excelIndexToCell(2,1) = " + ExcelCellUtils.excelIndexToCell(27, 26));
        ExcelWriter writer = ExcelUtil.getWriter((String)"C:\\Users\\JY\\Desktop\\\u8349\u7a3f.xlsx");
        writer.writeCellValue(0, 0, (Object)"A15555555555555555");
        writer.flush();
        writer.close();
    }
}

