/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.support.spring;

import cn.creekmoon.excel.core.ExcelUtilsConfig;
import cn.creekmoon.excel.support.spring.EnableExcelUtils;
import cn.creekmoon.excel.util.exception.GlobalExceptionMsgManager;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class ExcelUtilsAutoConfiguration
implements ImportSelector {
    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnableExcelUtils.class.getName(), true);
        for (String customExceptionName : (String[])annotationAttributes.get("customExceptions")) {
            ExcelUtilsConfig.addExcelUtilsExceptionHandler(new GlobalExceptionMsgManager.DirectMessageExceptionHandler(customExceptionName));
        }
        ExcelUtilsConfig.importParallelSemaphore = new Semaphore(Math.max((Integer)annotationAttributes.get("importMaxParallel"), 1));
        ExcelUtilsConfig.TEMP_FILE_LIFE_MINUTES = Math.max((Integer)annotationAttributes.get("tempFileLifeMinutes"), ExcelUtilsConfig.TEMP_FILE_LIFE_MINUTES);
        return new String[]{ExcelUtilsConfig.class.getName()};
    }
}

