/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.core.W.title.ext;

import cn.creekmoon.excel.core.W.title.ext.ConditionCellStyle;
import cn.hutool.core.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public class Title {
    public Title parentTitle;
    public String titleName;
    public Function valueFunction;
    public int startColIndex;
    public int endColIndex;
    public String PARENT_TITLE_SEPARATOR = "::";
    public List<ConditionCellStyle> conditionCellStyleList = new ArrayList<ConditionCellStyle>();

    private Title() {
    }

    public static Title of(String titleName, Function valueFunction, ConditionCellStyle ... conditionCellStyles) {
        Title newTitle = new Title();
        newTitle.titleName = titleName;
        newTitle.valueFunction = valueFunction;
        if (conditionCellStyles != null && conditionCellStyles.length > 0) {
            newTitle.conditionCellStyleList.addAll(Arrays.asList(conditionCellStyles));
        }
        return newTitle;
    }

    public HashMap<Integer, Title> convert2ChainTitle(int currentColIndex) {
        this.startColIndex = currentColIndex;
        this.endColIndex = currentColIndex;
        HashMap<Integer, Title> depth2Title = new HashMap<Integer, Title>();
        depth2Title.put(1, this);
        if (this.titleName.contains(this.PARENT_TITLE_SEPARATOR)) {
            String[] split = (String[])ArrayUtil.reverse((Object[])this.titleName.split(this.PARENT_TITLE_SEPARATOR));
            this.titleName = split[0];
            Title currentTitle = this;
            for (int i = 0; i < split.length; ++i) {
                int depth = i + 1;
                if (depth != split.length) {
                    Title parentTitle = new Title();
                    parentTitle.titleName = split[depth];
                    parentTitle.startColIndex = currentColIndex;
                    parentTitle.endColIndex = currentColIndex;
                    currentTitle.parentTitle = parentTitle;
                }
                depth2Title.put(depth, currentTitle);
                currentTitle = currentTitle.parentTitle;
            }
        }
        return depth2Title;
    }
}

