/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.core.W.title;

import cn.creekmoon.excel.core.W.ExcelExport;
import cn.creekmoon.excel.core.W.title.TitleWriter;
import cn.creekmoon.excel.core.W.title.ext.ConditionCellStyle;
import cn.creekmoon.excel.core.W.title.ext.ExcelCellStyle;
import cn.creekmoon.excel.core.W.title.ext.Title;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.BigExcelWriter;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.style.StyleUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HutoolTitleWriter<R>
extends TitleWriter<R> {
    private static final Logger log = LoggerFactory.getLogger(HutoolTitleWriter.class);
    protected ExcelExport parent;
    public BigExcelWriter bigExcelWriter;
    protected int currentRow = 0;

    public HutoolTitleWriter(ExcelExport parent, Integer sheetIndex) {
        this.parent = parent;
        this.sheetIndex = sheetIndex;
        this.sheetName = "Sheet" + sheetIndex;
    }

    @Override
    public int countTitles() {
        return this.titles.size();
    }

    @Override
    protected void preWrite() {
        super.preWrite();
        this.getBigExcelWriter().setSheet(this.sheetName);
        this.initTitles();
    }

    @Override
    protected void doWrite(List<R> targetDataList) {
        List splitDataList = ListUtil.partition(targetDataList, (int)100);
        for (int i = 0; i < splitDataList.size(); ++i) {
            int startRowIndex = this.getBigExcelWriter().getCurrentRow();
            this.getBigExcelWriter().write(((List)splitDataList.get(i)).stream().map(this::changeToCellValues).toList());
            int endRowIndex = this.getBigExcelWriter().getCurrentRow();
            this.currentRow = this.getBigExcelWriter().getCurrentRow();
            for (int k = 0; k < endRowIndex - startRowIndex; ++k) {
                for (int colIndex = 0; colIndex < this.titles.size(); ++colIndex) {
                    int finalI = i;
                    int finalK = k;
                    CellStyle runningTimeCellStyle = ((Title)this.titles.get((int)colIndex)).conditionCellStyleList.stream().filter(Objects::nonNull).filter(x -> x.getCondition().test(((List)splitDataList.get(finalI)).get(finalK))).map(ConditionCellStyle::getDefaultCellStyle).map(this::getRunningTimeCellStyle).findAny().orElse(null);
                    if (runningTimeCellStyle == null) continue;
                    this.getBigExcelWriter().setStyle(runningTimeCellStyle, colIndex, k + startRowIndex);
                }
            }
        }
    }

    private List<Object> changeToCellValues(R dataObject) {
        LinkedList<Object> row = new LinkedList<Object>();
        for (Title title : this.titles) {
            Object data;
            block3: {
                data = null;
                try {
                    data = title.valueFunction.apply(dataObject);
                }
                catch (Exception exception) {
                    if (!this.parent.debugger) break block3;
                    log.info("[Excel\u6784\u5efa]\u751f\u6210Excel\u83b7\u53d6\u6570\u636e\u503c\u65f6\u53d1\u751f\u9519\u8bef!\u5df2\u7ecf\u5ffd\u7565\u9519\u8bef\u5e76\u8bbe\u7f6e\u4e3aNULL\u503c!", (Throwable)exception);
                }
            }
            row.add(data);
        }
        return row;
    }

    private void initTitles() {
        int i;
        if (this.isTitleInitialized()) {
            return;
        }
        this.MAX_TITLE_DEPTH = this.titles.stream().map(x -> StrUtil.count((CharSequence)x.titleName, (CharSequence)x.PARENT_TITLE_SEPARATOR) + 1).max(Comparator.naturalOrder()).orElse(1);
        if (this.parent.debugger) {
            System.out.println("[Excel\u6784\u5efa] \u8868\u5934\u6df1\u5ea6\u83b7\u53d6\u6210\u529f! \u8868\u5934\u6700\u5927\u6df1\u5ea6\u4e3a" + this.MAX_TITLE_DEPTH);
        }
        for (i = 0; i < this.titles.size(); ++i) {
            Title oneTitle = (Title)this.titles.get(i);
            this.changeTitleWithMaxlength(oneTitle);
            HashMap<Integer, Title> map = oneTitle.convert2ChainTitle(i);
            map.forEach((depth, title) -> {
                if (!this.depth2Titles.containsKey(depth)) {
                    this.depth2Titles.put(depth, new ArrayList());
                }
                ((List)this.depth2Titles.get(depth)).add(title);
            });
        }
        for (i = 1; i <= this.MAX_TITLE_DEPTH; ++i) {
            Integer rowsIndex = this.getRowsIndexByDepth(i);
            int finalI = i;
            Map collect = ((List)this.depth2Titles.get(i)).stream().collect(Collectors.groupingBy(title -> {
                if (finalI == 1) {
                    return title;
                }
                Title x = title;
                StringBuilder groupName = new StringBuilder(x.titleName);
                while (x.parentTitle != null) {
                    groupName.insert(0, x.parentTitle.titleName + x.PARENT_TITLE_SEPARATOR);
                    x = x.parentTitle;
                }
                return groupName.toString();
            }, Collectors.toList()));
            collect.values().forEach(list -> {
                int endColIndex;
                int startColIndex = list.stream().map(x -> x.startColIndex).min(Comparator.naturalOrder()).orElse(1);
                if (startColIndex == (endColIndex = list.stream().map(x -> x.endColIndex).max(Comparator.naturalOrder()).orElse(1).intValue())) {
                    if (this.parent.debugger) {
                        System.out.println("[Excel\u6784\u5efa] \u63d2\u5165\u8868\u5934[" + ((Title)list.get((int)0)).titleName + "]");
                    }
                    this.getBigExcelWriter().getOrCreateCell(startColIndex, rowsIndex.intValue()).setCellValue(((Title)list.get((int)0)).titleName);
                    this.getBigExcelWriter().getOrCreateCell(startColIndex, rowsIndex.intValue()).setCellStyle(this.getBigExcelWriter().getHeadCellStyle());
                    return;
                }
                if (this.parent.debugger) {
                    System.out.println("[Excel\u6784\u5efa] \u63d2\u5165\u8868\u5934\u5e76\u6a2a\u5411\u5408\u5e76[" + ((Title)list.get((int)0)).titleName + "]\u9884\u8ba1\u5408\u5e76\u683c\u6570[" + (endColIndex - startColIndex) + "]");
                }
                this.getBigExcelWriter().merge(rowsIndex.intValue(), rowsIndex.intValue(), startColIndex, endColIndex, (Object)((Title)list.get((int)0)).titleName, true);
                if (this.parent.debugger) {
                    System.out.println("[Excel\u6784\u5efa] \u6a2a\u5411\u5408\u5e76\u8868\u5934[" + ((Title)list.get((int)0)).titleName + "]\u5b8c\u6bd5");
                }
            });
            this.getBigExcelWriter().setCurrentRow(this.getBigExcelWriter().getCurrentRow() + 1);
        }
        for (int colIndex = 0; colIndex < this.titles.size(); ++colIndex) {
            Title title2 = (Title)this.titles.get(colIndex);
            int sameCount = 0;
            Integer depth2 = 1;
            while (depth2 <= this.MAX_TITLE_DEPTH) {
                if (title2.parentTitle != null && title2.titleName.equals(title2.parentTitle.titleName)) {
                    ++sameCount;
                } else if (sameCount != 0) {
                    if (this.parent.debugger) {
                        System.out.println("[Excel\u6784\u5efa] \u8868\u5934\u7eb5\u5411\u5408\u5e76" + title2.titleName + "  \u9884\u8ba1\u5408\u5e76\u683c\u6570" + sameCount);
                    }
                    this.getBigExcelWriter().merge(this.getRowsIndexByDepth(depth2).intValue(), this.getRowsIndexByDepth(depth2) + sameCount, colIndex, colIndex, (Object)title2.titleName, true);
                    sameCount = 0;
                }
                title2 = title2.parentTitle;
                Integer n = depth2;
                depth2 = depth2 + 1;
            }
        }
        this.setColumnWidthDefault();
    }

    private boolean isTitleInitialized() {
        return this.MAX_TITLE_DEPTH != null;
    }

    private void restTitles() {
        this.MAX_TITLE_DEPTH = null;
        this.titles.clear();
        this.depth2Titles.clear();
    }

    public HutoolTitleWriter<R> setColumnWidthDefault() {
        this.setColumnWidth(500, 20);
        return this;
    }

    public void setColumnWidthAuto() {
        try {
            this.getBigExcelWriter().autoSizeColumnAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColumnWidth(int cols, int width) {
        for (int i = 0; i < cols; ++i) {
            try {
                this.getBigExcelWriter().setColumnWidth(i, width);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Integer getRowsIndexByDepth(int depth) {
        return this.MAX_TITLE_DEPTH - depth;
    }

    private Title changeTitleWithMaxlength(Title title) {
        int currentMaxDepth = StrUtil.count((CharSequence)title.titleName, (CharSequence)title.PARENT_TITLE_SEPARATOR) + 1;
        if (this.MAX_TITLE_DEPTH != currentMaxDepth) {
            String[] split = title.titleName.split(title.PARENT_TITLE_SEPARATOR);
            String lastTitleName = split[split.length - 1];
            for (int y = 0; y < this.MAX_TITLE_DEPTH - currentMaxDepth; ++y) {
                title.titleName = title.titleName + title.PARENT_TITLE_SEPARATOR + lastTitleName;
            }
        }
        return title;
    }

    public BigExcelWriter getBigExcelWriter() {
        if (this.bigExcelWriter == null && this.parent.sheetIndex2SheetWriter.containsKey((Object)(this.sheetIndex - 1))) {
            this.bigExcelWriter = ((HutoolTitleWriter)this.parent.sheetIndex2SheetWriter.get((Object)Integer.valueOf((int)(this.sheetIndex.intValue() - 1)))).bigExcelWriter;
        }
        if (this.bigExcelWriter == null) {
            this.bigExcelWriter = ExcelUtil.getBigWriter((String)this.parent.getResultFilePath());
        }
        return this.bigExcelWriter;
    }

    @Override
    public Workbook getWorkbook() {
        return this.getBigExcelWriter().getWorkbook();
    }

    @Override
    protected CellStyle getRunningTimeCellStyle(ExcelCellStyle style) {
        Object cached = this.parent.metadatas.get(style);
        if (cached != null) {
            return (CellStyle)cached;
        }
        Workbook workbook = this.getWorkbook();
        CellStyle newCellStyle = StyleUtil.createDefaultCellStyle((Workbook)workbook);
        style.getStyleInitializer().accept(workbook, newCellStyle);
        this.parent.metadatas.put(style, newCellStyle);
        return newCellStyle;
    }

    @Override
    protected void onSwitchSheet() {
        this.getBigExcelWriter().setSheet(this.sheetIndex.intValue());
    }

    @Override
    protected void stopWrite() {
        if (!this.parent.metadatas.containsKey("HUTOOL_TITLE_WRITER_CLOSED")) {
            this.getBigExcelWriter().close();
            this.parent.metadatas.put("HUTOOL_TITLE_WRITER_CLOSED", null);
        }
    }
}

