/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.core.W;

import cn.creekmoon.excel.core.W.Writer;
import cn.creekmoon.excel.core.W.title.HutoolTitleWriter;
import cn.creekmoon.excel.core.W.title.TitleWriter;
import cn.creekmoon.excel.util.ExcelFileUtils;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.text.StrFormatter;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelExport {
    private static final Logger log = LoggerFactory.getLogger(ExcelExport.class);
    public boolean debugger = false;
    protected String taskId = UUID.randomUUID().toString();
    protected String resultFilePath = ExcelFileUtils.generateXlsxAbsoluteFilePath(this.taskId);
    public String excelName;
    public HashMap<Object, Object> metadatas = new HashMap();
    public BiMap<Integer, Writer> sheetIndex2SheetWriter = new BiMap(new HashMap());

    private ExcelExport() {
    }

    public static ExcelExport create() {
        ExcelExport excelExport = new ExcelExport();
        excelExport.excelName = "export_result_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm")) + ".xlsx";
        return excelExport;
    }

    public <T> TitleWriter<T> switchSheet(Integer sheetIndex, Class<T> newDataClass) {
        if (this.sheetIndex2SheetWriter.containsKey((Object)sheetIndex)) {
            return (TitleWriter)this.sheetIndex2SheetWriter.get((Object)sheetIndex);
        }
        if (!this.sheetIndex2SheetWriter.containsKey((Object)(sheetIndex - 1))) {
            throw new RuntimeException(StrFormatter.format((String)"\u5207\u6362sheet\u9875\u5931\u8d25,\u9884\u671f\u5207\u6362\u5230sheet\u7d22\u5f15={}, \u4f46\u5f53\u524d\u6700\u5927\u7d22\u5f15\u4e0b\u6807sheet={},\u8bf7\u68c0\u67e5\u4ee3\u7801\u5e76\u4fdd\u8bc1sheet\u9875\u4e0b\u6807\u8fde\u7eed!", (Object[])new Object[0]));
        }
        return this.switchNewSheet(newDataClass);
    }

    public <T> TitleWriter<T> switchNewSheet(Class<T> newDataClass) {
        HutoolTitleWriter newTitleWriter = new HutoolTitleWriter(this, this.sheetIndex2SheetWriter.size());
        this.sheetIndex2SheetWriter.put((Object)newTitleWriter.getSheetIndex(), newTitleWriter);
        return newTitleWriter;
    }

    public ExcelExport debug() {
        this.debugger = true;
        return this;
    }

    public void response(HttpServletResponse response) throws IOException {
        File file = this.stopWrite();
        ExcelFileUtils.response(file, this.excelName, response);
    }

    public File stopWrite() {
        Workbook workbook = ((Writer)this.sheetIndex2SheetWriter.get((Object)0)).getWorkbook();
        this.sheetIndex2SheetWriter.values().stream().sorted(Comparator.comparing(Writer::getSheetIndex)).peek(x -> workbook.setSheetOrder(x.getSheetName(), x.getSheetIndex().intValue())).forEach(Writer::stopWrite);
        return new File(this.getResultFilePath());
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getResultFilePath() {
        return this.resultFilePath;
    }
}

