/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.core.R.readerResult.title;

import cn.creekmoon.excel.core.R.readerResult.ReaderResult;
import cn.creekmoon.excel.util.exception.ExBiConsumer;
import cn.creekmoon.excel.util.exception.ExConsumer;
import cn.creekmoon.excel.util.exception.GlobalExceptionMsgManager;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.text.StrFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitleReaderResult<R>
extends ReaderResult<R> {
    private static final Logger log = LoggerFactory.getLogger(TitleReaderResult.class);
    public BiMap<Integer, R> rowIndex2dataBiMap = new BiMap(new LinkedHashMap());
    public LinkedHashMap<Integer, String> rowIndex2msg = new LinkedHashMap();

    public List<R> getAll() {
        if (((Boolean)this.EXISTS_READ_FAIL.get()).booleanValue()) {
            return new ArrayList();
        }
        return new ArrayList(this.rowIndex2dataBiMap.values());
    }

    @Override
    public TitleReaderResult<R> consume(ExConsumer<R> dataConsumer) {
        return this.consume((Integer index, R data) -> dataConsumer.accept(data));
    }

    public TitleReaderResult<R> consume(ExBiConsumer<Integer, R> rowIndexAndDataConsumer) {
        this.rowIndex2dataBiMap.forEach((rowIndex, data) -> {
            try {
                rowIndexAndDataConsumer.accept((Integer)rowIndex, (R)data);
                this.rowIndex2msg.put((Integer)rowIndex, "\u5bfc\u5165\u6210\u529f!");
            }
            catch (Exception e) {
                this.errorCount.incrementAndGet();
                String exceptionMsg = GlobalExceptionMsgManager.getExceptionMsg(e);
                this.errorReport.append(StrFormatter.format((String)"\u7b2c[{}]\u884c\u53d1\u751f\u9519\u8bef[{}]", (Object[])new Object[]{rowIndex + 1, exceptionMsg}));
                this.rowIndex2msg.put((Integer)rowIndex, exceptionMsg);
            }
        });
        return this;
    }

    public TitleReaderResult<R> setResultMsg(R data, String msg) {
        Integer i = this.getDataIndexOrNull(data);
        if (i == null) {
            return null;
        }
        this.rowIndex2msg.put(i, msg);
        return this;
    }

    private Integer getDataIndexOrNull(R data) {
        Integer i = (Integer)this.rowIndex2dataBiMap.getKey(data);
        if (i == null) {
            log.error("[Excel\u8bfb\u53d6\u5f02\u5e38]\u5bf9\u8c61\u4e0d\u5728\u8bfb\u53d6\u7ed3\u679c\u4e2d! [{}]", data);
            return null;
        }
        return i;
    }

    public String getResultMsg(R data) {
        Integer i = this.getDataIndexOrNull(data);
        if (i == null) {
            return null;
        }
        return this.rowIndex2msg.get(i);
    }

    public String getResultMsg(Integer rowIndex) {
        return this.rowIndex2msg.get(rowIndex);
    }

    public TitleReaderResult<R> setResultMsg(Integer rowIndex, String msg) {
        if (this.rowIndex2msg.containsKey(rowIndex)) {
            this.rowIndex2msg.put(rowIndex, msg);
        }
        return this;
    }

    public AtomicInteger getErrorCount() {
        return this.errorCount;
    }

    public Integer getDataLatestRowIndex() {
        return (Integer)this.rowIndex2msg.keySet().stream().max(Integer::compareTo).get();
    }

    public Integer getDataFirstRowIndex() {
        return (Integer)this.rowIndex2msg.keySet().stream().min(Integer::compareTo).get();
    }
}

