/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.core.R.reader.title;

import cn.creekmoon.excel.core.ExcelUtilsConfig;
import cn.creekmoon.excel.core.R.ExcelImport;
import cn.creekmoon.excel.core.R.reader.title.TitleReader;
import cn.creekmoon.excel.core.R.readerResult.ReaderResult;
import cn.creekmoon.excel.core.R.readerResult.title.TitleReaderResult;
import cn.creekmoon.excel.util.exception.CheckedExcelException;
import cn.creekmoon.excel.util.exception.ExConsumer;
import cn.creekmoon.excel.util.exception.ExFunction;
import cn.creekmoon.excel.util.exception.GlobalExceptionMsgManager;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelFileUtil;
import cn.hutool.poi.excel.sax.ExcelSaxReader;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HutoolTitleReader<R>
extends TitleReader<R> {
    private static final Logger log = LoggerFactory.getLogger(HutoolTitleReader.class);

    public HutoolTitleReader(ExcelImport parent, Integer sheetIndex, Supplier newObjectSupplier) {
        super(parent);
        this.readerResult = new TitleReaderResult();
        this.sheetIndex = sheetIndex;
        this.newObjectSupplier = newObjectSupplier;
    }

    @Override
    public Long getSheetRowCount() {
        final AtomicLong result = new AtomicLong(0L);
        ExcelSaxReader excel07SaxReader = ExcelSaxUtil.createSaxReader((boolean)ExcelFileUtil.isXlsx((InputStream)this.getParent().sourceFile.getInputStream()), (RowHandler)new RowHandler(){

            public void handle(int sheetIndex, long rowIndex, List<Object> rowCells) {
                if (sheetIndex != HutoolTitleReader.this.sheetIndex) {
                    return;
                }
                result.incrementAndGet();
            }
        });
        try {
            excel07SaxReader.read(this.getParent().sourceFile.getInputStream(), -1);
        }
        catch (Exception e) {
            log.error("getSheetRowCount\u65b9\u6cd5\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        return result.get();
    }

    @Override
    public <T> HutoolTitleReader<R> addConvert(String title, ExFunction<String, T> convert, BiConsumer<R, T> setter) {
        this.title2converts.put(title, convert);
        this.title2consumers.put(title, setter);
        return this;
    }

    @Override
    public HutoolTitleReader<R> addConvert(String title, BiConsumer<R, String> reader) {
        this.addConvert(title, (T x) -> x, reader);
        return this;
    }

    @Override
    public <T> HutoolTitleReader<R> addConvertAndSkipEmpty(String title, BiConsumer<R, String> setter) {
        this.skipEmptyTitles.add(title);
        this.addConvert(title, (T x) -> x, setter);
        return this;
    }

    @Override
    public <T> HutoolTitleReader<R> addConvertAndSkipEmpty(String title, ExFunction<String, T> convert, BiConsumer<R, T> setter) {
        this.skipEmptyTitles.add(title);
        this.addConvert(title, (ExFunction)convert, (BiConsumer)setter);
        return this;
    }

    @Override
    public HutoolTitleReader<R> addConvertAndMustExist(String title, BiConsumer<R, String> setter) {
        this.mustExistTitles.add(title);
        this.addConvert(title, (T x) -> x, setter);
        return this;
    }

    @Override
    public <T> HutoolTitleReader<R> addConvertAndMustExist(String title, ExFunction<String, T> convert, BiConsumer<R, T> setter) {
        this.mustExistTitles.add(title);
        this.addConvert(title, (ExFunction)convert, (BiConsumer)setter);
        return this;
    }

    @Override
    public <T> HutoolTitleReader<R> addConvertPostProcessor(ExConsumer<R> postProcessor) {
        if (postProcessor != null) {
            this.convertPostProcessors.add(postProcessor);
        }
        return this;
    }

    @Override
    public TitleReaderResult<R> read(ExConsumer<R> dataConsumer) {
        ReaderResult result = ((TitleReaderResult)this.read()).consume((ExConsumer)dataConsumer);
        ((TitleReaderResult)this.getReadResult()).consumeSuccessTime = LocalDateTime.now();
        return result;
    }

    @Override
    public TitleReaderResult<R> read() {
        ExcelUtilsConfig.importParallelSemaphore.acquire();
        ((TitleReaderResult)this.getReadResult()).readStartTime = LocalDateTime.now();
        try {
            ExcelSaxReader saxReader = this.initSaxReader();
            saxReader.read(this.getParent().sourceFile.getInputStream(), -1);
        }
        catch (Exception e) {
            log.error("SaxReader\u8bfb\u53d6Excel\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            ((TitleReaderResult)this.getReadResult()).readSuccessTime = LocalDateTime.now();
            ExcelUtilsConfig.importParallelSemaphore.release();
        }
        return this.getReadResult();
    }

    @Override
    public HutoolTitleReader<R> range(int titleRowIndex, int firstDataRowIndex, int lastDataRowIndex) {
        this.titleRowIndex = titleRowIndex;
        this.firstRowIndex = firstDataRowIndex;
        this.latestRowIndex = lastDataRowIndex;
        return this;
    }

    @Override
    public HutoolTitleReader<R> range(int startRowIndex, int lastRowIndex) {
        return this.range(startRowIndex, startRowIndex + 1, lastRowIndex);
    }

    @Override
    public HutoolTitleReader<R> range(int startRowIndex) {
        return this.range(startRowIndex, startRowIndex + 1, Integer.MAX_VALUE);
    }

    private R rowConvert(Map<String, String> row) throws Exception {
        if (this.TEMPLATE_CONSISTENCY_CHECK_ENABLE && (this.TEMPLATE_CONSISTENCY_CHECK_FAILED || !this.templateConsistencyCheck(this.title2converts.keySet(), row.keySet()).booleanValue())) {
            this.TEMPLATE_CONSISTENCY_CHECK_FAILED = true;
            throw new CheckedExcelException("\u5bfc\u5165\u7684\u6a21\u677f\u6709\u8bef,\u8bf7\u68c0\u67e5\u60a8\u7684\u6587\u4ef6!");
        }
        this.TEMPLATE_CONSISTENCY_CHECK_ENABLE = false;
        if (this.ENABLE_BLANK_ROW_FILTER && row.values().stream().allMatch(x -> x == null || "".equals(x))) {
            return null;
        }
        Object convertObject = this.newObjectSupplier.get();
        int maxConvertCount = this.title2consumers.keySet().size();
        for (Map.Entry<String, String> entry : row.entrySet()) {
            if (!this.title2consumers.containsKey(entry.getKey()) || maxConvertCount-- <= 0) continue;
            String value = Optional.ofNullable(entry.getValue()).map(x -> x).orElse("");
            if (StrUtil.isBlank((CharSequence)value)) {
                if (this.mustExistTitles.contains(entry.getKey())) {
                    throw new CheckedExcelException(StrFormatter.format((String)"\u5b57\u6bb5[{}]\u4e3a\u5fc5\u586b\u9879! ", (Object[])new Object[]{entry.getKey()}));
                }
                if (this.skipEmptyTitles.contains(entry.getKey())) continue;
            }
            try {
                Object convertValue = this.title2converts.get(entry.getKey()).apply(value);
                this.title2consumers.get(entry.getKey()).accept(convertObject, convertValue);
            }
            catch (Exception e) {
                log.warn("EXCEL\u5bfc\u5165\u6570\u636e\u8f6c\u6362\u5931\u8d25\uff01", (Throwable)e);
                throw new CheckedExcelException(StrFormatter.format((String)("\u5b57\u6bb5[{}]\u89e3\u6790\u5931\u8d25\uff01" + GlobalExceptionMsgManager.getExceptionMsg(e)), (Object[])new Object[]{entry.getKey()}));
            }
        }
        return (R)convertObject;
    }

    ExcelSaxReader initSaxReader() throws IOException {
        final int targetSheetIndex = this.sheetIndex;
        ReaderResult titleReaderResult = this.getReadResult();
        return ExcelSaxUtil.createSaxReader((boolean)ExcelFileUtil.isXlsx((InputStream)this.getParent().sourceFile.getInputStream()), (RowHandler)new RowHandler(){
            final /* synthetic */ TitleReaderResult val$titleReaderResult;
            {
                this.val$titleReaderResult = titleReaderResult;
            }

            public void doAfterAllAnalysed() {
            }

            /*
             * Exception decompiling
             */
            public void handle(int sheetIndex, long rowIndex, List<Object> rowList) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.getBindingFor(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "res" is null
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.getGtbNullFiltered(GenericInferer.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.GenericInferer.inferGenericObjectInfoFromCalls(GenericInferer.java:139)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:484)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    private Boolean templateConsistencyCheck(Set<String> targetTitles, Set<String> sourceTitles) {
        if (targetTitles.size() > sourceTitles.size()) {
            return false;
        }
        return sourceTitles.containsAll(targetTitles);
    }

    public HutoolTitleReader<R> disableTemplateConsistencyCheck() {
        this.TEMPLATE_CONSISTENCY_CHECK_ENABLE = false;
        return this;
    }

    public HutoolTitleReader<R> disableBlankRowFilter() {
        this.ENABLE_BLANK_ROW_FILTER = false;
        return this;
    }

    @Override
    public Integer getSheetIndex() {
        return (Integer)this.getParent().sheetIndex2ReaderBiMap.getKey((Object)this);
    }

    @Override
    public TitleReaderResult<R> getReadResult() {
        return (TitleReaderResult)this.readerResult;
    }
}

