/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.core.R.reader.cell;

import cn.creekmoon.excel.core.ExcelUtilsConfig;
import cn.creekmoon.excel.core.R.ExcelImport;
import cn.creekmoon.excel.core.R.converter.StringConverter;
import cn.creekmoon.excel.core.R.reader.cell.CellReader;
import cn.creekmoon.excel.core.R.readerResult.ReaderResult;
import cn.creekmoon.excel.core.R.readerResult.cell.CellReaderResult;
import cn.creekmoon.excel.util.ExcelCellUtils;
import cn.creekmoon.excel.util.exception.CheckedExcelException;
import cn.creekmoon.excel.util.exception.ExConsumer;
import cn.creekmoon.excel.util.exception.ExFunction;
import cn.creekmoon.excel.util.exception.GlobalExceptionMsgManager;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.Excel07SaxReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.poi.ss.usermodel.CellStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HutoolCellReader<R>
extends CellReader<R> {
    private static final Logger log = LoggerFactory.getLogger(HutoolCellReader.class);

    public HutoolCellReader(ExcelImport parent, Integer sheetIndex, Supplier newObjectSupplier) {
        super(parent);
        this.readerResult = new CellReaderResult();
        this.sheetIndex = sheetIndex;
        this.newObjectSupplier = newObjectSupplier;
    }

    @Override
    public <T> HutoolCellReader<R> addConvert(String cellReference, ExFunction<String, T> convert, BiConsumer<R, T> setter) {
        return this.addConvert(ExcelCellUtils.excelCellToRowIndex(cellReference), ExcelCellUtils.excelCellToColumnIndex(cellReference), (ExFunction)convert, (BiConsumer)setter);
    }

    @Override
    public HutoolCellReader<R> addConvert(String cellReference, BiConsumer<R, String> reader) {
        return this.addConvert(ExcelCellUtils.excelCellToRowIndex(cellReference), ExcelCellUtils.excelCellToColumnIndex(cellReference), (T x) -> x, reader);
    }

    @Override
    public <T> HutoolCellReader<R> addConvert(int rowIndex, int colIndex, ExFunction<String, T> convert, BiConsumer<R, T> setter) {
        this.cell2converts.computeIfAbsent(rowIndex, HashMap::new);
        ((HashMap)this.cell2converts.get(rowIndex)).put(colIndex, convert);
        this.cell2setter.computeIfAbsent(rowIndex, HashMap::new);
        ((HashMap)this.cell2setter.get(rowIndex)).put(colIndex, setter);
        return this;
    }

    @Override
    public HutoolCellReader<R> addConvert(int rowIndex, int colIndex, BiConsumer<R, String> setter) {
        return this.addConvert(rowIndex, colIndex, (T x) -> x, setter);
    }

    @Override
    public <T> HutoolCellReader<R> addConvertAndSkipEmpty(int rowIndex, int colIndex, BiConsumer<R, String> setter) {
        return this.addConvertAndSkipEmpty(rowIndex, colIndex, (T x) -> x, setter);
    }

    @Override
    public <T> HutoolCellReader<R> addConvertAndSkipEmpty(int rowIndex, int colIndex, ExFunction<String, T> convert, BiConsumer<R, T> setter) {
        this.skipEmptyCells.computeIfAbsent(rowIndex, HashSet::new);
        ((Set)this.skipEmptyCells.get(rowIndex)).add(colIndex);
        return this.addConvert(rowIndex, colIndex, (ExFunction)convert, (BiConsumer)setter);
    }

    @Override
    public <T> HutoolCellReader<R> addConvertAndSkipEmpty(String cellReference, ExFunction<String, T> convert, BiConsumer<R, T> setter) {
        return this.addConvertAndSkipEmpty(ExcelCellUtils.excelCellToRowIndex(cellReference), ExcelCellUtils.excelCellToColumnIndex(cellReference), (ExFunction)convert, (BiConsumer)setter);
    }

    @Override
    public HutoolCellReader<R> addConvertAndSkipEmpty(String cellReference, BiConsumer<R, String> setter) {
        return this.addConvertAndSkipEmpty(cellReference, (T x) -> x, (BiConsumer)setter);
    }

    @Override
    public <T> HutoolCellReader<R> addConvertAndMustExist(int rowIndex, int colIndex, ExFunction<String, T> convert, BiConsumer<R, T> setter) {
        this.mustExistCells.computeIfAbsent(rowIndex, HashSet::new);
        ((Set)this.mustExistCells.get(rowIndex)).add(colIndex);
        return this.addConvert(rowIndex, colIndex, (ExFunction)convert, (BiConsumer)setter);
    }

    @Override
    public HutoolCellReader<R> addConvertAndMustExist(int rowIndex, int colIndex, BiConsumer<R, String> setter) {
        return this.addConvertAndMustExist(rowIndex, colIndex, (T x) -> x, setter);
    }

    @Override
    public HutoolCellReader<R> addConvertAndMustExist(String cellReference, BiConsumer<R, String> setter) {
        return this.addConvertAndMustExist(ExcelCellUtils.excelCellToRowIndex(cellReference), ExcelCellUtils.excelCellToColumnIndex(cellReference), (BiConsumer)setter);
    }

    @Override
    public ReaderResult<R> read(ExConsumer<R> consumer) throws Exception {
        return this.read().consume(consumer);
    }

    @Override
    public ReaderResult<R> read() throws InterruptedException, IOException {
        ExcelUtilsConfig.importParallelSemaphore.acquire();
        ((CellReaderResult)this.getReadResult()).readStartTime = LocalDateTime.now();
        try {
            HashSet<String> templateConsistencyCheckCells = new HashSet<String>();
            if (this.TEMPLATE_CONSISTENCY_CHECK_ENABLE) {
                this.cell2setter.forEach((rowIndex, colIndexMap) -> colIndexMap.forEach((colIndex, var) -> templateConsistencyCheckCells.add(ExcelCellUtils.excelIndexToCell(rowIndex, colIndex))));
            }
            Excel07SaxReader excel07SaxReader = this.initSaxReader(templateConsistencyCheckCells);
            excel07SaxReader.read(this.getParent().sourceFile.getInputStream(), -1);
            if (this.TEMPLATE_CONSISTENCY_CHECK_ENABLE && !templateConsistencyCheckCells.isEmpty()) {
                ((CellReaderResult)this.getReadResult()).EXISTS_READ_FAIL.set(true);
                ((CellReaderResult)this.getReadResult()).errorCount.incrementAndGet();
                ((CellReaderResult)this.getReadResult()).errorReport.append(StrFormatter.format((String)"\u5bfc\u5165\u7684\u6a21\u677f\u6709\u8bef,\u8bf7\u68c0\u67e5\u60a8\u7684\u6587\u4ef6!", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("SaxReader\u8bfb\u53d6Excel\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            ((CellReaderResult)this.getReadResult()).readSuccessTime = LocalDateTime.now();
            ExcelUtilsConfig.importParallelSemaphore.release();
        }
        return this.getReadResult();
    }

    @Override
    public CellReaderResult<R> getReadResult() {
        return (CellReaderResult)this.readerResult;
    }

    Excel07SaxReader initSaxReader(final Set<String> templateConsistencyCheckCells) {
        final Integer targetSheetIndex = this.sheetIndex;
        this.currentNewObject = this.newObjectSupplier.get();
        return new Excel07SaxReader(new RowHandler(){
            int currentSheetIndex = 0;

            public void handle(int sheetIndex, long rowIndex, List<Object> rowList) {
            }

            public void handleCell(int sheetIndex, long rowIndex, int cellIndex, Object value, CellStyle xssfCellStyle) {
                this.currentSheetIndex = sheetIndex;
                int colIndex = cellIndex;
                if (targetSheetIndex != this.currentSheetIndex) {
                    return;
                }
                if (HutoolCellReader.this.cell2setter.size() <= 0 || !HutoolCellReader.this.cell2setter.containsKey((int)rowIndex) || !((HashMap)HutoolCellReader.this.cell2setter.get((int)rowIndex)).containsKey(colIndex)) {
                    return;
                }
                templateConsistencyCheckCells.remove(ExcelCellUtils.excelIndexToCell((int)rowIndex, colIndex));
                try {
                    ExFunction cellConverter = (ExFunction)((HashMap)HutoolCellReader.this.cell2converts.get((int)rowIndex)).get(colIndex);
                    BiConsumer cellConsumer = (BiConsumer)((HashMap)HutoolCellReader.this.cell2setter.get((int)rowIndex)).get(colIndex);
                    String cellValue = StringConverter.parse(value);
                    if (StrUtil.isBlank((CharSequence)cellValue)) {
                        if (HutoolCellReader.this.mustExistCells.containsKey((int)rowIndex) && ((Set)HutoolCellReader.this.mustExistCells.get((int)rowIndex)).contains(colIndex)) {
                            throw new CheckedExcelException(StrFormatter.format((String)"\u5b57\u6bb5[{}]\u4e3a\u5fc5\u586b\u9879! ", (Object[])new Object[]{ExcelCellUtils.excelIndexToCell((int)rowIndex, colIndex)}));
                        }
                        if (HutoolCellReader.this.skipEmptyCells.containsKey((int)rowIndex) && ((Set)HutoolCellReader.this.skipEmptyCells.get((int)rowIndex)).contains(colIndex)) {
                            return;
                        }
                    }
                    Object apply = cellConverter.apply(cellValue);
                    cellConsumer.accept(HutoolCellReader.this.currentNewObject, apply);
                    ((CellReaderResult)HutoolCellReader.this.getReadResult()).setData(HutoolCellReader.this.currentNewObject);
                }
                catch (Exception e) {
                    ((CellReaderResult)HutoolCellReader.this.getReadResult()).EXISTS_READ_FAIL.set(true);
                    ((CellReaderResult)HutoolCellReader.this.getReadResult()).errorCount.incrementAndGet();
                    ((CellReaderResult)HutoolCellReader.this.getReadResult()).errorReport.append(StrFormatter.format((String)"\u5b57\u6bb5[{}]\u89e3\u6790\u5931\u8d25\uff01", (Object[])new Object[]{ExcelCellUtils.excelIndexToCell((int)rowIndex, colIndex)})).append(GlobalExceptionMsgManager.getExceptionMsg(e)).append(";");
                }
            }
        });
    }

    @Override
    public Integer getSheetIndex() {
        return (Integer)this.getParent().sheetIndex2ReaderBiMap.getKey((Object)this);
    }
}

