/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.core.R.converter;

import cn.creekmoon.excel.util.exception.CheckedExcelException;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConverter {
    private static final Logger log = LoggerFactory.getLogger(DateConverter.class);
    public static final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final BigDecimal BIG_DECIMAL_24 = new BigDecimal(24);
    private static final BigDecimal BIG_DECIMAL_60 = new BigDecimal(60);
    private static final BigDecimal BIG_DECIMAL_1000 = new BigDecimal(1000);
    private static final LocalDateTime EXCEL_START_TIME = LocalDateTime.of(1899, 12, 30, 0, 0);

    public static Date parse(String dateStr) throws CheckedExcelException {
        try {
            if (NumberUtil.isNumber((CharSequence)dateStr)) {
                LocalDateTime start = EXCEL_START_TIME;
                if (dateStr.contains(".")) {
                    String[] split = dateStr.split("\\.");
                    dateStr = split[0];
                    BigDecimal multiply = new BigDecimal("0." + split[1]).multiply(BIG_DECIMAL_24).multiply(BIG_DECIMAL_60).multiply(BIG_DECIMAL_60).multiply(BIG_DECIMAL_1000);
                    start = start.plus(multiply.longValue(), ChronoUnit.MILLIS);
                }
                start = start.plus(new BigDecimal(dateStr).longValue(), ChronoUnit.DAYS);
                dateStr = start.format(fmt);
            }
            return DateUtil.parse((CharSequence)dateStr);
        }
        catch (Exception e) {
            log.warn("[DateConverter]\u6570\u636e\u683c\u5f0f\u89e3\u6790\u5931\u8d25! \u4e0d\u652f\u6301\u7684\u503c {}", (Object)dateStr, (Object)e);
            throw new CheckedExcelException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u683c\u5f0f!");
        }
    }
}

