/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.excel.core.R;

import cn.creekmoon.excel.core.R.reader.Reader;
import cn.creekmoon.excel.core.R.reader.cell.CellReader;
import cn.creekmoon.excel.core.R.reader.cell.HutoolCellReader;
import cn.creekmoon.excel.core.R.reader.title.HutoolTitleReader;
import cn.creekmoon.excel.core.R.reader.title.TitleReader;
import cn.creekmoon.excel.core.R.readerResult.title.TitleReaderResult;
import cn.creekmoon.excel.util.ExcelFileUtils;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.map.BiMap;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.BigExcelWriter;
import cn.hutool.poi.excel.ExcelUtil;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

public class ExcelImport {
    private static final Logger log = LoggerFactory.getLogger(ExcelImport.class);
    public BiMap<Integer, Reader> sheetIndex2ReaderBiMap = new BiMap(new HashMap());
    public String taskId = UUID.fastUUID().toString();
    String resultFilePath = ExcelFileUtils.generateXlsxAbsoluteFilePath(this.taskId);
    public MultipartFile sourceFile;

    private ExcelImport() {
    }

    public static ExcelImport create(MultipartFile file) throws IOException {
        ExcelImport excelImport = new ExcelImport();
        excelImport.sourceFile = file;
        excelImport.csvSupport();
        return excelImport;
    }

    public <T> TitleReader<T> switchSheet(int sheetIndex, Supplier<T> supplier) {
        if (supplier.get() == supplier.get()) {
            throw new RuntimeException("\u5bfc\u51fa\u7684\u5bf9\u8c61\u4e0d\u652f\u6301\u91cd\u5199 equal() \u65b9\u6cd5. \u8bf7\u52ff\u4f7f\u7528@Data\u6ce8\u89e3!");
        }
        if (supplier.get() == supplier.get()) {
            throw new RuntimeException("\u5bfc\u51fa\u7684\u5bf9\u8c61\u4e0d\u652f\u6301\u91cd\u5199 equal() \u65b9\u6cd5. \u8bf7\u52ff\u4f7f\u7528@Data\u6ce8\u89e3!");
        }
        TitleReader sheetReader = (TitleReader)this.sheetIndex2ReaderBiMap.get((Object)sheetIndex);
        if (sheetReader != null) {
            return sheetReader;
        }
        HutoolTitleReader reader = new HutoolTitleReader(this, sheetIndex, supplier);
        this.sheetIndex2ReaderBiMap.put((Object)sheetIndex, reader);
        return reader;
    }

    public <T> CellReader<T> switchSheetAndUseCellReader(int sheetIndex, Supplier<T> supplier) {
        CellReader sheetReader = (CellReader)this.sheetIndex2ReaderBiMap.get((Object)sheetIndex);
        if (sheetReader != null) {
            return sheetReader;
        }
        HutoolCellReader reader = new HutoolCellReader(this, sheetIndex, supplier);
        this.sheetIndex2ReaderBiMap.put((Object)sheetIndex, reader);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExcelImport csvSupport() {
        if (StrUtil.isBlank((CharSequence)this.sourceFile.getOriginalFilename()) || !this.sourceFile.getOriginalFilename().toLowerCase().contains(".csv")) {
            return this;
        }
        log.info("[\u6587\u4ef6\u5bfc\u5165]\u6536\u5230CSV\u683c\u5f0f\u7684\u6587\u4ef6[{}],\u5c1d\u8bd5\u8f6c\u5316\u4e3aXLSX\u683c\u5f0f", (Object)this.sourceFile.getOriginalFilename());
        String filePath = ExcelFileUtils.generateXlsxAbsoluteFilePath(UUID.fastUUID().toString(true));
        BigExcelWriter bigWriter = ExcelUtil.getBigWriter();
        try {
            CsvReader read = new CsvReader((java.io.Reader)new InputStreamReader(this.sourceFile.getInputStream()), null);
            Iterator rowIterator = read.iterator();
            while (rowIterator.hasNext()) {
                bigWriter.writeRow((Iterable)((CsvRow)rowIterator.next()).getRawList());
            }
        }
        catch (Exception e) {
            log.error("[\u6587\u4ef6\u5bfc\u5165]csv\u8f6c\u6362\u5f02\u5e38!", (Throwable)e);
            this.sourceFile = null;
        }
        finally {
            bigWriter.close();
            ExcelFileUtils.cleanTempFileByPathDelay(filePath, 120);
        }
        this.sourceFile = new MockMultipartFile("csv2xlsx.xlsx", (InputStream)FileUtil.getInputStream((String)filePath));
        return this;
    }

    public ExcelImport response(HttpServletResponse response) throws IOException {
        File file = this.generateResultFile();
        ExcelFileUtils.response(ExcelFileUtils.generateXlsxAbsoluteFilePath(this.taskId), this.taskId + ".xlsx", response);
        return this;
    }

    public File generateResultFile() throws IOException {
        return this.generateResultFile(true);
    }

    public File generateResultFile(boolean autoClean) throws IOException {
        String absoluteFilePath = this.resultFilePath;
        try (XSSFWorkbook workbook = new XSSFWorkbook(this.sourceFile.getInputStream());
             BufferedOutputStream outputStream = FileUtil.getOutputStream((String)absoluteFilePath);){
            for (Integer targetSheetIndex : this.sheetIndex2ReaderBiMap.keySet()) {
                Sheet sheet = workbook.getSheetAt(targetSheetIndex.intValue());
                Reader reader = (Reader)this.sheetIndex2ReaderBiMap.get((Object)targetSheetIndex);
                if (!(reader instanceof TitleReader)) continue;
                TitleReader titleReader = (TitleReader)reader;
                TitleReaderResult readerResult = (TitleReaderResult)reader.getReadResult();
                int titleRowIndex = titleReader.titleRowIndex;
                Integer lastTitleColumnIndex = (Integer)titleReader.colIndex2Title.keySet().stream().max(Integer::compareTo).get();
                int msgTitleColumnIndex = lastTitleColumnIndex + 1;
                Integer dataFirstRowIndex = readerResult.getDataFirstRowIndex();
                Integer dataLatestRowIndex = readerResult.getDataLatestRowIndex();
                CellStyle titleCellStyle = sheet.getRow(titleRowIndex).getCell(lastTitleColumnIndex.intValue()).getCellStyle();
                Cell cell1 = sheet.getRow(titleRowIndex).createCell(msgTitleColumnIndex);
                cell1.setCellStyle(titleCellStyle);
                cell1.setCellValue("\u5bfc\u5165\u7ed3\u679c");
                Integer rowIndex = dataFirstRowIndex;
                while (rowIndex <= dataLatestRowIndex) {
                    Cell cell = sheet.getRow(rowIndex.intValue()).createCell(msgTitleColumnIndex);
                    cell.setCellValue(readerResult.getResultMsg(rowIndex));
                    Integer n = rowIndex;
                    rowIndex = rowIndex + 1;
                }
            }
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
        }
        return FileUtil.file((String)absoluteFilePath);
    }
}

