/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.dict;

import cn.creekmoon.dict.Dict;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictHttpRefreshConfig {
    private static final Logger log = LoggerFactory.getLogger(DictHttpRefreshConfig.class);
    public static String lastMD5 = "md5";
    public static ScheduledExecutorService scheduledThreadPool = null;

    public static void enable(String url, Long refreshInterval) {
        if (scheduledThreadPool != null) {
            scheduledThreadPool.shutdownNow();
        }
        if (scheduledThreadPool == null) {
            scheduledThreadPool = Executors.newScheduledThreadPool(1);
        }
        scheduledThreadPool.scheduleWithFixedDelay(() -> DictHttpRefreshConfig.refresh(url), 0L, refreshInterval, TimeUnit.SECONDS);
    }

    private static void refresh(String url) {
        HttpRequest httpRequest = HttpRequest.get((String)url);
        try (HttpResponse httpResponse = httpRequest.execute();){
            String body = httpResponse.body();
            String currentMD5 = DigestUtil.md5Hex((String)body);
            if (lastMD5.equals(currentMD5)) {
                log.info("[\u5b9a\u65f6\u5237\u65b0\u5b57\u5178]======\u5b57\u5178\u5b9a\u65f6\u68c0\u67e5\u4e0e\u8fdc\u7aef\u4e00\u81f4\u65e0\u987b\u66f4\u65b0====");
                return;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)body);
            Map dict = (Map)jsonObject.toJavaObject(Map.class, new JSONReader.Feature[0]);
            Dict.addDictMap(dict);
            lastMD5 = currentMD5;
            log.info("[\u5b9a\u65f6\u5237\u65b0\u5b57\u5178]======\u5b57\u5178\u5b9a\u65f6\u66f4\u65b0\u6210\u529f====");
        }
        catch (Exception e) {
            log.error("[\u5b9a\u65f6\u5237\u65b0\u5b57\u5178]=======\u5b57\u5178\u66f4\u65b0\u5931\u8d25====", (Throwable)e);
        }
    }
}

