/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.dict;

import cn.creekmoon.dict.DictFieldTranslator;
import cn.creekmoon.dict.DictMapping;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson2.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Dict {
    public static final Logger log = LoggerFactory.getLogger(Dict.class);
    public static final List<String> businessPackagePathList = new ArrayList<String>();
    public static final Map<Class, DictFieldTranslator> translators = new ConcurrentHashMap<Class, DictFieldTranslator>();
    public static final Map<String, String> EMPTY_MAP = new HashMap<String, String>();
    public static final Map<String, List<String>> EMPTY_MAP_REVERSE = new HashMap<String, List<String>>();
    public static final Map<String, Map<String, String>> DICT_MAP = new ConcurrentHashMap<String, Map<String, String>>(512);
    public static final Map<String, Map<String, List<String>>> DICT_MAP_REVERSE = new ConcurrentHashMap<String, Map<String, List<String>>>(512);

    public static void addDictMap(Map<String, Map<String, String>> dictMap) {
        DICT_MAP.putAll(dictMap);
        DICT_MAP.forEach((k, v) -> DICT_MAP_REVERSE.put((String)k, v.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())))));
    }

    @Deprecated
    public static void setDictMap(Map<String, Map<String, String>> dictMap) {
        Dict.addDictMap(dictMap);
    }

    public static void setGlobalBusinessPackageNames(String ... basePackageNames) {
        businessPackagePathList.addAll(Arrays.asList(basePackageNames));
    }

    public static JSONObject getDict(Object object) {
        JSONObject result = new JSONObject();
        if (!Dict.isTranslatable(object)) {
            return null;
        }
        try {
            Field[] fields;
            for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
                boolean existsAnnotation;
                boolean bl = existsAnnotation = !field.isAnnotationPresent(DictMapping.class);
                if (existsAnnotation && Dict.isBusinessObjectType(field.getType())) {
                    JSONObject dict = Dict.getDict(ReflectUtil.getFieldValue((Object)object, (Field)field));
                    if (dict == null) continue;
                    result.put((Object)field.getName(), (Object)dict);
                    continue;
                }
                if (existsAnnotation && Collection.class.isAssignableFrom(field.getType())) {
                    Object collectionValue = ReflectUtil.getFieldValue((Object)object, (Field)field);
                    if (collectionValue == null) continue;
                    result.put((Object)field.getName(), ((Collection)collectionValue).stream().map(Dict::getDict).collect(Collectors.toList()));
                    continue;
                }
                if (existsAnnotation || result.get(field.getName()) != null) continue;
                result.put((Object)field.getName(), Dict.searchDictValue(object, field));
            }
            return result;
        }
        catch (Exception e) {
            log.error("\u7ffb\u8bd1\u5b57\u5178\u5931\u8d25\uff01", (Throwable)e);
            return new JSONObject();
        }
    }

    public static void fillSelf(Object object) {
        Field[] fields;
        if (!Dict.isTranslatable(object)) {
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            collection.forEach(Dict::fillSelf);
            return;
        }
        for (Field field : fields = ReflectUtil.getFields(object.getClass())) {
            if (Collection.class.isAssignableFrom(field.getType())) {
                Dict.fillSelf(ReflectUtil.getFieldValue((Object)object, (Field)field));
                continue;
            }
            if (Dict.isBusinessObjectType(field.getType())) {
                Dict.fillSelf(ReflectUtil.getFieldValue((Object)object, (Field)field));
                continue;
            }
            if (!field.isAnnotationPresent(DictMapping.class) || !field.getType().equals(String.class)) continue;
            ReflectUtil.setFieldValue((Object)object, (String)field.getName(), (Object)Dict.searchDictValue(object, field));
        }
    }

    public static String findPackagePath(Class<?> clazz) {
        int target = clazz.getName().indexOf(".");
        for (int num = 2; num > 0; --num) {
            target = clazz.getName().indexOf(".", target + 1);
        }
        return clazz.getName().substring(0, target);
    }

    public static boolean isBusinessObjectType(Class<?> clazz) {
        for (String basePath : businessPackagePathList) {
            if (!clazz.getName().startsWith(basePath)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTranslatable(Class<?> clazz) {
        return Dict.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz) || Dict.isBusinessObjectType(clazz);
    }

    public static boolean isTranslatable(Object o) {
        if (o == null) {
            return false;
        }
        return Dict.class.isAssignableFrom(o.getClass()) || Collection.class.isAssignableFrom(o.getClass()) || Dict.isBusinessObjectType(o.getClass());
    }

    public static Object searchDictValue(Object sourceObject, String fieldName) {
        Field field = ReflectUtil.getField(sourceObject.getClass(), (String)fieldName);
        if (field == null) {
            log.error("\u7ffb\u8bd1\u5b57\u5178\u5931\u8d25\uff01dictObject={}, fieldName={}", new Object[]{sourceObject, fieldName, new RuntimeException("\u7ffb\u8bd1\u5b57\u5178\u5931\u8d25\uff01\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01")});
            return null;
        }
        return Dict.searchDictValue(sourceObject, field);
    }

    public static String searchDictValue(String dictCode, String dictKey) {
        if (dictKey == null) {
            return null;
        }
        return DICT_MAP.getOrDefault(dictCode, EMPTY_MAP).get(dictKey);
    }

    public static String searchDictValueOrSelf(String dictCode, Object dictKey) {
        String result = Dict.searchDictValue(dictCode, String.valueOf(dictKey));
        if (dictKey == null) {
            return null;
        }
        if (result == null) {
            return StrUtil.toString((Object)dictKey);
        }
        return result;
    }

    public static <T> Object searchDictValue(T dictObject, Field field) {
        Field[] sourceFields;
        for (Field sourcefield : sourceFields = ReflectUtil.getFields(dictObject.getClass())) {
            try {
                if (!sourcefield.getName().equals(field.getName()) || !field.isAnnotationPresent(DictMapping.class)) continue;
                field.setAccessible(true);
                Object fieldValue = field.get(dictObject);
                field.setAccessible(false);
                DictMapping annotation = field.getAnnotation(DictMapping.class);
                if (!translators.containsKey(annotation.fieldTranslator())) {
                    try {
                        translators.put(annotation.fieldTranslator(), (DictFieldTranslator)annotation.fieldTranslator().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Exception e) {
                        RuntimeException runtimeException = new RuntimeException("\u5b57\u5178\u89e3\u6790\u5931\u8d25! \u65e0\u6cd5\u83b7\u53d6\u5230\u7ffb\u8bd1\u5668");
                        log.error("\u5b57\u5178\u89e3\u6790\u5931\u8d25! \u8bf7\u68c0\u67e5\u662f\u5426\u5df2\u7ecf\u5b9e\u73b0\u4e86DictFieldTranslator\u63a5\u53e3? field=[{}] annotation=[{}]", new Object[]{field, annotation, runtimeException});
                        throw runtimeException;
                    }
                }
                DictFieldTranslator dictFieldTranslator = translators.get(annotation.fieldTranslator());
                if (Collection.class.isAssignableFrom(sourcefield.getType()) && fieldValue != null) {
                    List collect = ((Collection)fieldValue).stream().map(x -> dictFieldTranslator.searchDictValue(dictObject, sourcefield, x, annotation)).collect(Collectors.toList());
                    return collect;
                }
                return dictFieldTranslator.searchDictValue(dictObject, sourcefield, fieldValue, annotation);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String searchDictKey(String dictCode, String dictValue) throws RuntimeException {
        if (dictValue == null) {
            return null;
        }
        List<String> dictKeys = DICT_MAP_REVERSE.getOrDefault(dictCode, EMPTY_MAP_REVERSE).get(dictValue);
        if (dictKeys.size() > 1) {
            throw new RuntimeException(StrFormatter.format((String)"\u5b57\u5178\u9879\uff1a{}\uff0c\u83b7\u53d6\u7684\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (Object[])new Object[]{dictValue}));
        }
        return dictKeys.get(0);
    }

    public static Map<String, String> getKeysMap(String dictCode) {
        if (StrUtil.isBlank((CharSequence)dictCode)) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(DICT_MAP.get(dictCode));
    }

    public static Map<String, Map<String, String>> getAll() {
        return Collections.unmodifiableMap(DICT_MAP);
    }

    default public JSONObject getDict() {
        return Dict.getDict(this);
    }

    default public void validate(Map<String, String> dict) {
    }

    default public void fillSelf() {
        Dict.fillSelf(this);
    }
}

