/*
 * Decompiled with CFR 0.152.
 */
package cn.creekmoon.dict;

import cn.creekmoon.dict.Dict;
import cn.creekmoon.dict.DictFieldTranslator;
import cn.creekmoon.dict.DictMapping;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;

public class DefaultDictFieldTranslator
implements DictFieldTranslator {
    @Override
    public String searchDictValue(Object dictObject, Field sourcefield, Object fieldValue, DictMapping annotationValue) {
        String dictCode;
        if (fieldValue == null) {
            return null;
        }
        String fieldValueStr = fieldValue.toString();
        if (StrUtil.isBlank((CharSequence)fieldValueStr)) {
            return fieldValueStr;
        }
        String suffix = annotationValue.suffix();
        String string = dictCode = annotationValue.dictCode().equals("AUTO") ? sourcefield.getName() : annotationValue.dictCode();
        if (fieldValueStr.contains(",")) {
            String[] values = fieldValueStr.split(",");
            String translatedResult = Arrays.stream(values).map(String::trim).map(value -> Dict.searchDictValueOrSelf(dictCode, value)).map(translatedValue -> translatedValue + suffix).collect(Collectors.joining(","));
            return translatedResult;
        }
        String result = Dict.searchDictValueOrSelf(dictCode, fieldValue);
        return result == null ? null : result + suffix;
    }
}

