/*
 * Decompiled with CFR 0.152.
 */
package cn.crazywalker.fsf.security;

import cn.crazywalker.fsf.common.util.StringUtils;
import cn.crazywalker.fsf.security.IllegalPasswordException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public class PasswordUtils {
    private static final PasswordEncoder PASSWORD_ENCODER = new BCryptPasswordEncoder();

    private PasswordUtils() {
    }

    public static String encode(String source) {
        if (!StringUtils.hasLength((String)source)) {
            throw new IllegalPasswordException("Source password can not be empty.");
        }
        return PASSWORD_ENCODER.encode((CharSequence)source);
    }

    public static boolean matches(String rawPassword, String encodePassword) {
        if (!StringUtils.hasLength((String)rawPassword) || !StringUtils.hasLength((String)encodePassword)) {
            return false;
        }
        return PASSWORD_ENCODER.matches((CharSequence)rawPassword, encodePassword);
    }
}

