package cn.crazywalker.fsf.page;

import com.github.pagehelper.Page;

import java.util.Collections;
import java.util.List;

/**
 * 分页查询结果类
 * @author CrazyWalker
 * @since 周日, 04/16 2023 20:26 GMT+8
 */
public class PageResult<T> {

    private Integer pageNumber;

    private Integer pageSize;

    private Long total;

    private List<T> list;

    public static <T> PageResult<T> of(Page<T> page) {
        PageResult<T> result = new PageResult<>();
        result.pageNumber = page.getPageNum();
        result.pageSize = page.getPageSize();
        result.total = page.getTotal();
        result.list = page;

        return result;
    }

    public static <T> PageResult<T> of(Page<?> page, List<T> list) {
        PageResult<T> result = new PageResult<>();
        result.pageNumber = page.getPageNum();
        result.pageSize = page.getPageSize();
        result.total = page.getTotal();
        result.list = list;

        return result;
    }

    public static <T> PageResult<T> empty() {
        PageResult<T> result = new PageResult<>();
        result.list = Collections.emptyList();
        result.pageNumber = 1;
        result.pageSize = 0;
        result.total = 0L;

        return result;
    }

    public Integer getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    @Override
    public String toString() {
        return "PageResult{" +
                "pageNumber=" + pageNumber +
                ", pageSize=" + pageSize +
                ", total=" + total +
                ", list=" + list +
                '}';
    }
}
