/*
 * Decompiled with CFR 0.152.
 */
package cn.crazywalker.fsf.page;

import com.github.pagehelper.Page;
import java.util.Collections;
import java.util.List;

public class PageResult<T> {
    private Integer pageNumber;
    private Integer pageSize;
    private Long total;
    private List<T> list;

    public static <T> PageResult<T> of(Page<T> page) {
        PageResult<T> result = new PageResult<T>();
        result.pageNumber = page.getPageNum();
        result.pageSize = page.getPageSize();
        result.total = page.getTotal();
        result.list = page;
        return result;
    }

    public static <T> PageResult<T> of(Page<?> page, List<T> list) {
        PageResult<T> result = new PageResult<T>();
        result.pageNumber = page.getPageNum();
        result.pageSize = page.getPageSize();
        result.total = page.getTotal();
        result.list = list;
        return result;
    }

    public static <T> PageResult<T> empty() {
        PageResult<T> result = new PageResult<T>();
        result.list = Collections.emptyList();
        result.pageNumber = 1;
        result.pageSize = 0;
        result.total = 0L;
        return result;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public String toString() {
        return "PageResult{pageNumber=" + this.pageNumber + ", pageSize=" + this.pageSize + ", total=" + this.total + ", list=" + this.list + '}';
    }
}

