package cn.crazywalker.fsf.page;

import com.github.pagehelper.IPage;

/**
 * 基础分页查询类
 * @author CrazyWalker
 * @since 周日, 04/16 2023 20:29 GMT+8
 */
public class PageQuery implements IPage {

    private Integer pageNumber;

    private Integer pageSize;

    private String orderBy;

    public boolean isValid() {
        return (pageNumber != null && pageNumber > -1)
                && (pageSize != null && pageSize > 0);
    }

    @Override
    public final Integer getPageNum() {
        return pageNumber;
    }

    public final Integer getPageNumber() {
        return pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public final Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public final String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Override
    public String toString() {
        return "PageQuery{" +
                "pageNumber=" + pageNumber +
                ", pageSize=" + pageSize +
                ", orderBy='" + orderBy + '\'' +
                '}';
    }
}
