/*
 * Decompiled with CFR 0.152.
 */
package cn.crazywalker.fsf.oss.aliyun;

import cn.crazywalker.fsf.oss.OSSClient;
import cn.crazywalker.fsf.oss.aliyun.AliyunOSSProperties;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class AliyunOSSClient
extends OSSClient
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliyunOSSClient.class);
    private final OSS client;
    private final String bucketName;
    private final String oosUrlPattern;

    public AliyunOSSClient(AliyunOSSProperties aliyunOSSProperties) {
        String endpoint = aliyunOSSProperties.getEndpoint();
        this.client = new OSSClientBuilder().build(endpoint, aliyunOSSProperties.getAccessKeyId(), aliyunOSSProperties.getAccessKeySecret());
        this.bucketName = aliyunOSSProperties.getBucketName();
        this.oosUrlPattern = "https://" + this.bucketName + "." + endpoint + "/{0}";
        LOGGER.info("\u5b8c\u6210aliyun oos client\u521d\u59cb\u5316: endpoint: [{}]", (Object)endpoint);
    }

    @Override
    public boolean simpleUpload(String name, byte[] fileBytes) {
        this.client.putObject(this.bucketName, name, (InputStream)new ByteArrayInputStream(fileBytes));
        return true;
    }

    @Override
    public String getPathByOosKey(String oosKey) {
        return MessageFormat.format(this.oosUrlPattern, oosKey);
    }

    public void destroy() throws Exception {
        this.client.shutdown();
    }
}

