/*
 * Decompiled with CFR 0.152.
 */
package cn.crazywalker.fsf.oss;

import cn.crazywalker.fsf.oss.OSSClient;
import cn.crazywalker.fsf.oss.OSSFileHandler;
import cn.crazywalker.fsf.oss.OSSService;
import cn.crazywalker.fsf.oss.exception.OSSException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class OSSServiceImpl
implements OSSService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSSServiceImpl.class);
    private static final String MODULE_NAME_EXCEPTION_MESSAGE_TEMPLATE = "OOSServiceImpl constructor: module name {0} is duplication.";
    private static final String MODULE_HANDLE_NOT_FOUND = "upload: handler for module name {0} is not found.";
    private static final String OOS_KEY_PATTERN = "{0}/{1}";
    private final OSSClient oosClient;
    private final Map<String, OSSFileHandler> moduleFileHandlerMap;

    public OSSServiceImpl(OSSClient aliyunOOSClient, List<OSSFileHandler> ossFileHandlerList) {
        this.oosClient = aliyunOOSClient;
        if (ossFileHandlerList == null) {
            this.moduleFileHandlerMap = new HashMap<String, OSSFileHandler>();
            return;
        }
        this.moduleFileHandlerMap = new HashMap<String, OSSFileHandler>(ossFileHandlerList.size());
        ossFileHandlerList.forEach(handler -> {
            String moduleName = handler.getModuleName();
            if (this.moduleFileHandlerMap.containsKey(moduleName)) {
                throw new OSSException(MessageFormat.format(MODULE_NAME_EXCEPTION_MESSAGE_TEMPLATE, moduleName));
            }
            this.moduleFileHandlerMap.put(moduleName, (OSSFileHandler)handler);
        });
    }

    @Override
    public String upload(String moduleName, Object uploadInfo, MultipartFile file) {
        OSSFileHandler handler = this.moduleFileHandlerMap.get(moduleName);
        if (handler == null) {
            throw new OSSException(MessageFormat.format(MODULE_HANDLE_NOT_FOUND, moduleName));
        }
        String filePath = handler.filePath(uploadInfo, file);
        try {
            byte[] fileBytes = file.getBytes();
            return this.innerUpload(moduleName, filePath, fileBytes);
        }
        catch (IOException e) {
            LOGGER.error("\u963f\u91cc\u4e91\u5bf9\u8c61\u5b58\u50a8\u4e0a\u4f20\u5931\u8d25: ", (Throwable)e);
            throw new OSSException("MultipartFile\u83b7\u53d6\u5b57\u8282\u6d41\u5931\u8d25.");
        }
    }

    @Override
    public String upload(String moduleName, Object uploadInfo, byte[] fileBytes) {
        OSSFileHandler handler = this.moduleFileHandlerMap.get(moduleName);
        if (handler == null) {
            throw new OSSException(MessageFormat.format(MODULE_HANDLE_NOT_FOUND, moduleName));
        }
        String filePath = handler.filePath(uploadInfo, fileBytes);
        return this.innerUpload(moduleName, filePath, fileBytes);
    }

    private String innerUpload(String moduleName, String filePath, byte[] fileBytes) {
        String oosKey = MessageFormat.format(OOS_KEY_PATTERN, moduleName, filePath);
        this.oosClient.simpleUpload(oosKey, fileBytes);
        return oosKey;
    }

    @Override
    public String getPath(String oosKey) {
        return this.oosClient.getPathByOosKey(oosKey);
    }
}

