/*
 * Decompiled with CFR 0.152.
 */
package cn.crazywalker.fsf.oss;

import java.util.Optional;
import org.springframework.web.multipart.MultipartFile;

public abstract class OSSFileHandler {
    private static final String EMPTY_STRING = "";
    private static final Integer ZERO = 0;
    private static final Integer NOT_OCCUR = -1;
    private static final Character DOT = Character.valueOf('.');

    public abstract String getModuleName();

    public abstract String filePath(Object var1, MultipartFile var2);

    public String filePath(Object info, byte[] fileBytes) {
        return EMPTY_STRING;
    }

    protected static String multipartFileTypeSuffix(MultipartFile file) {
        String typeName = OSSFileHandler.multipartFileType(file);
        return EMPTY_STRING.equals(typeName) ? typeName : DOT + typeName;
    }

    private static String multipartFileType(MultipartFile file) {
        boolean hasTypeName;
        Optional<String> filenameOptional = Optional.ofNullable(file.getOriginalFilename());
        int dot = filenameOptional.map(s -> s.lastIndexOf(DOT.charValue())).orElse(NOT_OCCUR);
        int length = filenameOptional.map(String::length).orElse(ZERO);
        String type = EMPTY_STRING;
        boolean bl = hasTypeName = !NOT_OCCUR.equals(dot);
        if (!hasTypeName) {
            return type;
        }
        return file.getOriginalFilename().substring(dot + 1, length);
    }
}

