package cn.crazywalker.exception.handler;

import cn.crazywalker.exception.BusinessException;
import cn.crazywalker.exception.SystemException;
import cn.crazywalker.fsf.common.exception.FlyingSpurBaseException;
import cn.crazywalker.fsf.vo.BaseVo;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * 异常处理器
 * @author CrazyWalker
 * @since 周二, 04/18 2023 23:36 GMT+8
 */
@RestControllerAdvice(annotations = FsfControllerAdvice.class)
public class ControllerExceptionHandler {
    @ExceptionHandler({BusinessException.class})
    @ResponseStatus(HttpStatus.OK)
    public BaseVo<?> handleBusinessException(BusinessException e) {
        return new BaseVo<>(e.getCode(), e.getMessage(), false, e.getData());
    }

    @ExceptionHandler({SystemException.class})
    @ResponseStatus(HttpStatus.OK)
    public BaseVo<?> handleSystemException(SystemException e) {
        return new BaseVo<>(e.getCode(), e.getMessage(), false, e.getData());
    }

    @ExceptionHandler({FlyingSpurBaseException.class})
    @ResponseStatus(HttpStatus.OK)
    public BaseVo<?> handleBusinessException(FlyingSpurBaseException e) {
        return new BaseVo<>(3000, "Unknown Error.", false);
    }
}
