package cn.crazywalker.exception;

import cn.crazywalker.fsf.common.exception.FlyingSpurBaseException;

/**
 * 业务逻辑异常类
 * @author CrazyWalker
 * @since 周二, 04/18 2023 23:28 GMT+8
 */
public class BusinessException extends FlyingSpurBaseException {

    private Integer code;

    private Object data;

    public BusinessException(Integer code, String message) {
        super(message);
        this.code = code;
    }

    public BusinessException(Integer code, String message, Object data) {
        super(message);
        this.code = code;
        this.data = data;
    }

    public BusinessException(ExceptionInfo exceptionInfo) {
        super(exceptionInfo.getMessage());
        this.code = exceptionInfo.getCode();
    }

    public BusinessException(ExceptionInfo exceptionInfo, Object data) {
        super(exceptionInfo.getMessage());
        this.code = exceptionInfo.getCode();
        this.data = data;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "BusinessException{" +
                "code=" + code +
                ", data=" + data +
                '}';
    }
}
