package cn.crazywalker.exception;

import cn.crazywalker.fsf.common.exception.FlyingSpurBaseException;

/**
 * 系统异常类
 * @author CrazyWalker
 * @since 周二, 04/18 2023 23:27 GMT+8
 */
public class SystemException extends FlyingSpurBaseException {

    private Integer code;

    private Object data;

    public SystemException(Integer code, String message) {
        super(message);
        this.code = code;
    }

    public SystemException(Integer code, String message, Object data) {
        super(message);
        this.code = code;
        this.data = data;
    }

    public SystemException(ExceptionInfo exceptionInfo) {
        super(exceptionInfo.getMessage());
        this.code = exceptionInfo.getCode();
    }

    public SystemException(ExceptionInfo exceptionInfo, Object data) {
        super(exceptionInfo.getMessage());
        this.code = exceptionInfo.getCode();
        this.data = data;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "BusinessException{" +
                "code=" + code +
                ", data=" + data +
                '}';
    }
}
