/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.spring.boot.config;

import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.extension.mybatis.plus.AssembleMpAnnotationHandler;
import cn.crane4j.extension.mybatis.plus.MybatisPlusQueryContainerProvider;
import cn.crane4j.spring.boot.config.Crane4jAutoConfiguration;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={Properties.class})
@ConditionalOnClass(value={MybatisPlusAutoConfiguration.class, AssembleMpAnnotationHandler.class})
@AutoConfigureAfter(value={MybatisPlusAutoConfiguration.class, Crane4jAutoConfiguration.class})
public class Crane4jMybatisPlusAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MybatisPlusQueryContainerProvider mybatisPlusQueryContainerProvider(MethodInvokerContainerCreator methodInvokerContainerCreator, Crane4jGlobalConfiguration globalConfiguration, ApplicationContext applicationContext) {
        return new MybatisPlusQueryContainerProvider(methodInvokerContainerCreator, globalConfiguration, mapperName -> (BaseMapper)applicationContext.getBean(mapperName, BaseMapper.class));
    }

    @Bean
    @ConditionalOnMissingBean
    public AssembleMpAnnotationHandler assembleMpAnnotationResolver(AnnotationFinder annotationFinder, MybatisPlusQueryContainerProvider mybatisPlusQueryContainerProvider, Crane4jGlobalConfiguration globalConfiguration, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        return new AssembleMpAnnotationHandler(annotationFinder, mybatisPlusQueryContainerProvider, globalConfiguration, propertyMappingStrategyManager);
    }

    @ConditionalOnProperty(prefix="crane4j.mybatis-plus", name={"auto-register-mapper"}, havingValue="true")
    @Bean
    @ConditionalOnMissingBean
    public BaseMapperAutoRegistrar baseMapperAutoRegistrar(ApplicationContext applicationContext, Properties crane4jMybatisPlusProperties) {
        return new BaseMapperAutoRegistrar(applicationContext, crane4jMybatisPlusProperties);
    }

    @Bean(value={"Crane4jMybatisPlusAutoConfigurationInitializationLogger"})
    public InitializationLogger initializationLogger() {
        return new InitializationLogger();
    }

    public static class InitializationLogger
    implements ApplicationRunner {
        private static final Logger log = LoggerFactory.getLogger(InitializationLogger.class);

        public void run(ApplicationArguments args) {
            log.info("crane4j mybatis-plus extension initialization completed!");
        }
    }

    public static class BaseMapperAutoRegistrar
    implements ApplicationRunner {
        private static final Logger log = LoggerFactory.getLogger(BaseMapperAutoRegistrar.class);
        private final ApplicationContext applicationContext;
        private final Properties properties;

        public void run(ApplicationArguments args) {
            if (!this.properties.isAutoRegisterMapper()) {
                return;
            }
            Set<String> includes = this.properties.getIncludes();
            Set<String> excludes = this.properties.getExcludes();
            includes.removeAll(excludes);
            BiPredicate<String, BaseMapper> mapperFilter = includes.isEmpty() ? (n, m) -> !excludes.contains(n) : (n, m) -> includes.contains(n) && !excludes.contains(n);
            Map mappers = this.applicationContext.getBeansOfType(BaseMapper.class);
            MybatisPlusQueryContainerProvider register = (MybatisPlusQueryContainerProvider)this.applicationContext.getBean(MybatisPlusQueryContainerProvider.class);
            mappers.entrySet().stream().filter(e -> mapperFilter.test((String)e.getKey(), (BaseMapper)e.getValue())).forEach(e -> register.registerRepository((String)e.getKey(), e.getValue()));
            log.info("crane4j mybatis-plus extension component initialization completed.");
        }

        public BaseMapperAutoRegistrar(ApplicationContext applicationContext, Properties properties) {
            this.applicationContext = applicationContext;
            this.properties = properties;
        }
    }

    @ConfigurationProperties(prefix="crane4j.mybatis-plus")
    public static class Properties {
        public static final String CRANE4J_MP_EXTENSION_PREFIX = "crane4j.mybatis-plus";
        private Set<String> includes = new HashSet<String>();
        private Set<String> excludes = new HashSet<String>();
        private boolean autoRegisterMapper = false;

        public Set<String> getIncludes() {
            return this.includes;
        }

        public Set<String> getExcludes() {
            return this.excludes;
        }

        public boolean isAutoRegisterMapper() {
            return this.autoRegisterMapper;
        }

        public void setIncludes(Set<String> includes) {
            this.includes = includes;
        }

        public void setExcludes(Set<String> excludes) {
            this.excludes = excludes;
        }

        public void setAutoRegisterMapper(boolean autoRegisterMapper) {
            this.autoRegisterMapper = autoRegisterMapper;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Properties)) {
                return false;
            }
            Properties other = (Properties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAutoRegisterMapper() != other.isAutoRegisterMapper()) {
                return false;
            }
            Set<String> this$includes = this.getIncludes();
            Set<String> other$includes = other.getIncludes();
            if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
                return false;
            }
            Set<String> this$excludes = this.getExcludes();
            Set<String> other$excludes = other.getExcludes();
            return !(this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Properties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAutoRegisterMapper() ? 79 : 97);
            Set<String> $includes = this.getIncludes();
            result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
            Set<String> $excludes = this.getExcludes();
            result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
            return result;
        }

        public String toString() {
            return "Crane4jMybatisPlusAutoConfiguration.Properties(includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ", autoRegisterMapper=" + this.isAutoRegisterMapper() + ")";
        }
    }
}

