/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.spring.boot.config;

import cn.crane4j.annotation.ContainerConstant;
import cn.crane4j.annotation.ContainerEnum;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.cache.ConcurrentMapCacheManager;
import cn.crane4j.core.container.ConstantContainer;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.container.lifecycle.CacheableContainerProcessor;
import cn.crane4j.core.container.lifecycle.ContainerInstanceLifecycleProcessor;
import cn.crane4j.core.container.lifecycle.ContainerRegisterLogger;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.DisorderedBeanOperationExecutor;
import cn.crane4j.core.executor.OrderedBeanOperationExecutor;
import cn.crane4j.core.executor.handler.ManyToManyAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToManyAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToOneAssembleOperationHandler;
import cn.crane4j.core.executor.handler.ReflectiveDisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.TypeHierarchyBeanOperationParser;
import cn.crane4j.core.parser.handler.AssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleEnumAnnotationHandler;
import cn.crane4j.core.parser.handler.DisassembleAnnotationHandler;
import cn.crane4j.core.parser.handler.OperationAnnotationHandler;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.OperateTemplate;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.support.SimpleTypeResolver;
import cn.crane4j.core.support.Sorted;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.aop.AutoOperateAnnotatedElementResolver;
import cn.crane4j.core.support.container.CacheableMethodContainerFactory;
import cn.crane4j.core.support.container.DefaultMethodContainerFactory;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.support.expression.MethodBaseExpressionExecuteDelegate;
import cn.crane4j.core.support.operator.DefaultOperatorProxyMethodFactory;
import cn.crane4j.core.support.operator.DynamicContainerOperatorProxyMethodFactory;
import cn.crane4j.core.support.operator.OperatorProxyFactory;
import cn.crane4j.core.support.operator.OperatorProxyMethodFactory;
import cn.crane4j.core.support.reflect.AsmReflectivePropertyOperator;
import cn.crane4j.core.support.reflect.CacheablePropertyOperator;
import cn.crane4j.core.support.reflect.ChainAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.MapAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.extension.spring.BeanMethodContainerRegistrar;
import cn.crane4j.extension.spring.Crane4jApplicationContext;
import cn.crane4j.extension.spring.MergedAnnotationFinder;
import cn.crane4j.extension.spring.ResolvableExpressionEvaluator;
import cn.crane4j.extension.spring.SpringAssembleAnnotationHandler;
import cn.crane4j.extension.spring.SpringConverterManager;
import cn.crane4j.extension.spring.SpringParameterNameFinder;
import cn.crane4j.extension.spring.aop.MethodArgumentAutoOperateAdvisor;
import cn.crane4j.extension.spring.aop.MethodResultAutoOperateAdvisor;
import cn.crane4j.extension.spring.expression.SpelExpressionContext;
import cn.crane4j.extension.spring.expression.SpelExpressionEvaluator;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

@Configuration
@EnableConfigurationProperties(value={Properties.class})
public class Crane4jAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(Crane4jAutoConfiguration.class);
    public static final String CRANE_PREFIX = "crane4j";

    @ConditionalOnBean(value={ConversionService.class})
    @ConditionalOnMissingBean(value={ConverterManager.class})
    @Bean
    public SpringConverterManager springConverterManager(ConversionService conversionService) {
        return new SpringConverterManager(conversionService);
    }

    @ConditionalOnMissingBean(value={ConversionService.class, ConverterManager.class})
    @Bean
    public SpringConverterManager newSpringConverterManager() {
        log.info("No ConversionService or ConverterManager bean found, use default ConversionService.");
        return new SpringConverterManager(DefaultConversionService.getSharedInstance());
    }

    @Primary
    @ConditionalOnMissingBean
    @Bean
    public Crane4jApplicationContext crane4jApplicationContext(ApplicationContext applicationContext) {
        return new Crane4jApplicationContext(applicationContext);
    }

    @Bean
    public PropertyOperator propertyOperator(Properties properties, ConverterManager converterManager) {
        ReflectivePropertyOperator operator = properties.isEnableAsmReflect() && System.getProperty("java.version").contains("1.8") ? new AsmReflectivePropertyOperator(converterManager) : new ReflectivePropertyOperator(converterManager);
        operator = new CacheablePropertyOperator((PropertyOperator)operator);
        if (properties.isEnableMapOperate()) {
            operator = new MapAccessiblePropertyOperator((PropertyOperator)operator);
        }
        if (properties.isEnableChainOperate()) {
            operator = new ChainAccessiblePropertyOperator((PropertyOperator)operator);
        }
        return operator;
    }

    @ConditionalOnMissingBean(value={AnnotationFinder.class})
    @Bean
    public MergedAnnotationFinder mergedAnnotationFinder() {
        return new MergedAnnotationFinder();
    }

    @ConditionalOnMissingBean(value={TypeResolver.class})
    @Bean
    public SimpleTypeResolver simpleTypeResolver() {
        return new SimpleTypeResolver();
    }

    @ConditionalOnMissingBean(value={ExpressionEvaluator.class})
    @Bean
    public SpelExpressionEvaluator spelExpressionEvaluator() {
        return new SpelExpressionEvaluator((ExpressionParser)new SpelExpressionParser());
    }

    @ConditionalOnMissingBean(value={CacheManager.class})
    @Bean
    public ConcurrentMapCacheManager concurrentMapCacheManager() {
        return new ConcurrentMapCacheManager(CollectionUtils::newWeakConcurrentMap);
    }

    @Order(value=0)
    @Bean
    public ContainerInstanceLifecycleProcessor containerInstanceLifecycleProcessor() {
        return new ContainerInstanceLifecycleProcessor();
    }

    @Order(value=1)
    @Bean
    public ContainerRegisterLogger containerRegisterLogger() {
        Logger logger = LoggerFactory.getLogger(ContainerRegisterLogger.class);
        return new ContainerRegisterLogger((arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1));
    }

    @Order(value=2)
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={CacheManager.class})
    @Bean
    public CacheableContainerProcessor cacheableContainerProcessor(CacheManager cacheManager, Properties properties) {
        HashMap cacheMap = new HashMap(16);
        properties.getCacheContainers().forEach((cacheName, namespaces) -> namespaces.forEach(namespace -> cacheMap.put(namespace, cacheName)));
        CacheableContainerProcessor processor = new CacheableContainerProcessor(cacheManager);
        processor.setCacheNameSelector((definition, container) -> (String)cacheMap.get(container.getNamespace()));
        return processor;
    }

    @ConditionalOnMissingBean(value={BeanResolver.class})
    @Bean
    public BeanFactoryResolver beanFactoryResolver(ApplicationContext applicationContext) {
        return new BeanFactoryResolver((BeanFactory)applicationContext);
    }

    @ConditionalOnMissingBean(value={AssembleAnnotationHandler.class})
    @Bean
    public SpringAssembleAnnotationHandler springAssembleAnnotationResolver(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration, ExpressionEvaluator evaluator, BeanResolver beanResolver, Properties properties) {
        return new SpringAssembleAnnotationHandler(annotationFinder, configuration, evaluator, beanResolver);
    }

    @ConditionalOnMissingBean
    @Bean
    public DisassembleAnnotationHandler disassembleAnnotationOperationsResolver(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration) {
        return new DisassembleAnnotationHandler(annotationFinder, configuration);
    }

    @ConditionalOnMissingBean
    @Bean
    public AssembleEnumAnnotationHandler assembleEnumAnnotationResolver(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, PropertyOperator propertyOperator, ContainerManager containerManager) {
        return new AssembleEnumAnnotationHandler(annotationFinder, globalConfiguration, propertyOperator, containerManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public TypeHierarchyBeanOperationParser typeHierarchyBeanOperationParser(Collection<OperationAnnotationHandler> resolvers) {
        TypeHierarchyBeanOperationParser parser = new TypeHierarchyBeanOperationParser();
        resolvers.forEach(arg_0 -> ((TypeHierarchyBeanOperationParser)parser).addBeanOperationsResolver(arg_0));
        return parser;
    }

    @Primary
    @ConditionalOnMissingBean
    @Bean
    public DisorderedBeanOperationExecutor disorderedBeanOperationExecutor(ContainerManager containerManager) {
        return new DisorderedBeanOperationExecutor(containerManager);
    }

    @ConditionalOnMissingBean
    @Bean
    public OrderedBeanOperationExecutor orderedBeanOperationExecutor(ContainerManager containerManager) {
        return new OrderedBeanOperationExecutor(containerManager, Comparator.comparing(Sorted::getSort));
    }

    @ConditionalOnMissingBean
    @Bean
    public MethodInvokerContainerCreator methodInvokerContainerCreator(PropertyOperator propertyOperator, ConverterManager converterManager) {
        return new MethodInvokerContainerCreator(propertyOperator, converterManager);
    }

    @Order
    @Bean
    public DefaultMethodContainerFactory defaultMethodContainerFactory(MethodInvokerContainerCreator methodInvokerContainerCreator, AnnotationFinder annotationFinder) {
        return new DefaultMethodContainerFactory(methodInvokerContainerCreator, annotationFinder);
    }

    @Order(value=0x7FFFFFFE)
    @ConditionalOnBean(value={CacheManager.class})
    @Bean
    public CacheableMethodContainerFactory cacheableMethodContainerFactory(CacheManager cacheManager, MethodInvokerContainerCreator methodInvokerContainerCreator, AnnotationFinder annotationFinder) {
        return new CacheableMethodContainerFactory(methodInvokerContainerCreator, annotationFinder, cacheManager);
    }

    @Primary
    @Bean
    public OneToOneAssembleOperationHandler oneToOneAssembleOperationHandler(PropertyOperator propertyOperator) {
        return new OneToOneAssembleOperationHandler(propertyOperator);
    }

    @Bean
    public ManyToManyAssembleOperationHandler manyToManyAssembleOperationHandler(PropertyOperator propertyOperator) {
        return new ManyToManyAssembleOperationHandler(propertyOperator);
    }

    @Bean
    public OneToManyAssembleOperationHandler oneToManyAssembleOperationHandler(PropertyOperator propertyOperator) {
        return new OneToManyAssembleOperationHandler(propertyOperator);
    }

    @Primary
    @ConditionalOnMissingBean
    @Bean
    public ReflectiveDisassembleOperationHandler reflectiveDisassembleOperationHandler(PropertyOperator propertyOperator) {
        return new ReflectiveDisassembleOperationHandler(propertyOperator);
    }

    @ConditionalOnMissingBean(value={OperatorProxyMethodFactory.class})
    @Bean
    public OperatorProxyFactory operatorProxyFactory(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration, Collection<OperatorProxyMethodFactory> factories) {
        OperatorProxyFactory factory = new OperatorProxyFactory(configuration, annotationFinder);
        factories.forEach(arg_0 -> ((OperatorProxyFactory)factory).addProxyMethodFactory(arg_0));
        return factory;
    }

    @ConditionalOnBean(value={OperatorProxyFactory.class})
    @ConditionalOnMissingBean
    @Bean
    public DefaultOperatorProxyMethodFactory defaultProxyMethodFactory(ConverterManager converterManager) {
        return new DefaultOperatorProxyMethodFactory(converterManager);
    }

    @ConditionalOnBean(value={OperatorProxyFactory.class})
    @ConditionalOnMissingBean
    @Order
    @Bean
    public DynamicContainerOperatorProxyMethodFactory dynamicContainerOperatorProxyMethodFactory(ConverterManager converterManager, ParameterNameFinder parameterNameFinder, AnnotationFinder annotationFinder) {
        return new DynamicContainerOperatorProxyMethodFactory(converterManager, parameterNameFinder, annotationFinder);
    }

    @ConditionalOnMissingBean
    @Bean
    public OperateTemplate operateTemplate(BeanOperationParser parser, BeanOperationExecutor executor, TypeResolver typeResolver) {
        return new OperateTemplate(parser, executor, typeResolver);
    }

    @ConditionalOnMissingBean(value={ParameterNameFinder.class})
    @Bean
    public SpringParameterNameFinder springParameterNameFinder() {
        return new SpringParameterNameFinder((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
    }

    @ConditionalOnMissingBean
    @Bean
    public AutoOperateAnnotatedElementResolver autoOperateMethodAnnotatedElementResolver(Crane4jGlobalConfiguration crane4jGlobalConfiguration, TypeResolver typeResolver) {
        return new AutoOperateAnnotatedElementResolver(crane4jGlobalConfiguration, typeResolver);
    }

    @ConditionalOnMissingBean
    @Bean
    public ResolvableExpressionEvaluator resolvableExpressionEvaluator(ExpressionEvaluator expressionEvaluator, ParameterNameFinder parameterNameFinder, BeanResolver beanResolver) {
        return new ResolvableExpressionEvaluator(parameterNameFinder, expressionEvaluator, method -> {
            SpelExpressionContext context = new SpelExpressionContext(method);
            context.setBeanResolver(beanResolver);
            return context;
        });
    }

    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="crane4j", name={"enable-method-result-auto-operate"}, havingValue="true", matchIfMissing=true)
    @Bean
    public MethodResultAutoOperateAdvisor methodResultAutoOperateAdvisor(AutoOperateAnnotatedElementResolver autoOperateAnnotatedElementResolver, ResolvableExpressionEvaluator resolvableExpressionEvaluator) {
        return new MethodResultAutoOperateAdvisor(autoOperateAnnotatedElementResolver, (MethodBaseExpressionExecuteDelegate)resolvableExpressionEvaluator);
    }

    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="crane4j", name={"enable-method-argument-auto-operate"}, havingValue="true", matchIfMissing=true)
    @Bean
    public MethodArgumentAutoOperateAdvisor methodArgumentAutoOperateAdvisor(MethodBaseExpressionExecuteDelegate methodBaseExpressionExecuteDelegate, AutoOperateAnnotatedElementResolver autoOperateAnnotatedElementResolver, ParameterNameFinder parameterNameDiscoverer, AnnotationFinder annotationFinder) {
        return new MethodArgumentAutoOperateAdvisor(autoOperateAnnotatedElementResolver, methodBaseExpressionExecuteDelegate, parameterNameDiscoverer, annotationFinder);
    }

    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="crane4j", name={"enable-method-container"}, havingValue="true", matchIfMissing=true)
    @Bean
    public BeanMethodContainerRegistrar beanMethodContainerPostProcessor(AnnotationFinder annotationFinder, Collection<MethodContainerFactory> factories, Crane4jGlobalConfiguration configuration) {
        return new BeanMethodContainerRegistrar(factories, annotationFinder, configuration);
    }

    @ConditionalOnMissingBean
    @Bean
    public Crane4jInitializer crane4jInitializer(MetadataReaderFactory readerFactory, ResourcePatternResolver resolver, PropertyOperator propertyOperator, ApplicationContext applicationContext, AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration, Properties properties) {
        return new Crane4jInitializer(readerFactory, resolver, propertyOperator, applicationContext, properties, annotationFinder, configuration);
    }

    @Bean
    public InitializationLogger initializationLogger() {
        return new InitializationLogger();
    }

    public static class InitializationLogger
    implements ApplicationRunner {
        private static final Logger log = LoggerFactory.getLogger(InitializationLogger.class);

        public void run(ApplicationArguments args) {
            log.info("Initialized crane4j components......");
        }
    }

    public static class Crane4jInitializer
    implements ApplicationRunner {
        private static final Logger log = LoggerFactory.getLogger(Crane4jInitializer.class);
        private final MetadataReaderFactory readerFactory;
        private final ResourcePatternResolver resolver;
        private final PropertyOperator propertyOperator;
        private final ApplicationContext applicationContext;
        private final Properties properties;
        private final AnnotationFinder annotationFinder;
        private final Crane4jGlobalConfiguration configuration;

        public void run(ApplicationArguments args) {
            log.info("start initializing crane4j components......");
            this.loadContainerEnum();
            this.loadConstantClass();
            this.loadOperateEntity();
        }

        private void loadConstantClass() {
            Set<String> constantPackages = this.properties.getContainerConstantPackages();
            constantPackages.forEach(path -> this.readMetadata((String)path, reader -> {
                Class targetType = ClassUtils.forName((String)reader.getClassMetadata().getClassName());
                if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)targetType, ContainerConstant.class)) {
                    ConstantContainer container = ConstantContainer.forConstantClass((Class)targetType, (AnnotationFinder)this.annotationFinder);
                    this.configuration.registerContainer((Container)container);
                }
            }));
        }

        private void loadContainerEnum() {
            Set<String> enumPackages = this.properties.getContainerEnumPackages();
            enumPackages.forEach(path -> this.readMetadata((String)path, reader -> {
                boolean supported;
                Class targetType = ClassUtils.forName((String)reader.getClassMetadata().getClassName());
                boolean bl = supported = targetType.isEnum() && (!this.properties.isOnlyLoadAnnotatedEnum() || AnnotatedElementUtils.isAnnotated((AnnotatedElement)targetType, ContainerEnum.class));
                if (supported) {
                    ConstantContainer container = ConstantContainer.forEnum((Class)targetType, (AnnotationFinder)this.annotationFinder, (PropertyOperator)this.propertyOperator);
                    this.configuration.registerContainer((Container)container);
                }
            }));
        }

        private void loadOperateEntity() {
            Set<String> entityPackages = this.properties.getOperateEntityPackages();
            entityPackages.forEach(path -> this.readMetadata((String)path, reader -> {
                Class targetType = ClassUtils.forName((String)reader.getClassMetadata().getClassName());
                this.applicationContext.getBeansOfType(BeanOperationParser.class).values().forEach(parser -> parser.parse((AnnotatedElement)targetType));
            }));
        }

        private void readMetadata(String path, Consumer<MetadataReader> consumer) {
            Resource[] resources;
            String actualPath = ClassUtils.packageToPath((String)path);
            for (Resource resource : resources = this.resolver.getResources(actualPath)) {
                MetadataReader reader = this.readerFactory.getMetadataReader(resource);
                consumer.accept(reader);
            }
        }

        public Crane4jInitializer(MetadataReaderFactory readerFactory, ResourcePatternResolver resolver, PropertyOperator propertyOperator, ApplicationContext applicationContext, Properties properties, AnnotationFinder annotationFinder, Crane4jGlobalConfiguration configuration) {
            this.readerFactory = readerFactory;
            this.resolver = resolver;
            this.propertyOperator = propertyOperator;
            this.applicationContext = applicationContext;
            this.properties = properties;
            this.annotationFinder = annotationFinder;
            this.configuration = configuration;
        }
    }

    @ConfigurationProperties(prefix="crane4j")
    public static class Properties {
        private boolean enableMapOperate = true;
        private boolean enableChainOperate = true;
        private boolean enableAsmReflect = false;
        private Set<String> containerEnumPackages = new LinkedHashSet<String>();
        private boolean onlyLoadAnnotatedEnum = false;
        private Set<String> containerConstantPackages = new LinkedHashSet<String>();
        private Set<String> operateEntityPackages = new LinkedHashSet<String>();
        private boolean enableMethodArgumentAutoOperate = true;
        private boolean enableMethodResultAutoOperate = true;
        private boolean enableMethodContainer = true;
        private Map<String, Set<String>> cacheContainers = new LinkedHashMap<String, Set<String>>();

        public boolean isEnableMapOperate() {
            return this.enableMapOperate;
        }

        public boolean isEnableChainOperate() {
            return this.enableChainOperate;
        }

        public boolean isEnableAsmReflect() {
            return this.enableAsmReflect;
        }

        public Set<String> getContainerEnumPackages() {
            return this.containerEnumPackages;
        }

        public boolean isOnlyLoadAnnotatedEnum() {
            return this.onlyLoadAnnotatedEnum;
        }

        public Set<String> getContainerConstantPackages() {
            return this.containerConstantPackages;
        }

        public Set<String> getOperateEntityPackages() {
            return this.operateEntityPackages;
        }

        public boolean isEnableMethodArgumentAutoOperate() {
            return this.enableMethodArgumentAutoOperate;
        }

        public boolean isEnableMethodResultAutoOperate() {
            return this.enableMethodResultAutoOperate;
        }

        public boolean isEnableMethodContainer() {
            return this.enableMethodContainer;
        }

        public Map<String, Set<String>> getCacheContainers() {
            return this.cacheContainers;
        }

        public Properties setEnableMapOperate(boolean enableMapOperate) {
            this.enableMapOperate = enableMapOperate;
            return this;
        }

        public Properties setEnableChainOperate(boolean enableChainOperate) {
            this.enableChainOperate = enableChainOperate;
            return this;
        }

        public Properties setEnableAsmReflect(boolean enableAsmReflect) {
            this.enableAsmReflect = enableAsmReflect;
            return this;
        }

        public Properties setContainerEnumPackages(Set<String> containerEnumPackages) {
            this.containerEnumPackages = containerEnumPackages;
            return this;
        }

        public Properties setOnlyLoadAnnotatedEnum(boolean onlyLoadAnnotatedEnum) {
            this.onlyLoadAnnotatedEnum = onlyLoadAnnotatedEnum;
            return this;
        }

        public Properties setContainerConstantPackages(Set<String> containerConstantPackages) {
            this.containerConstantPackages = containerConstantPackages;
            return this;
        }

        public Properties setOperateEntityPackages(Set<String> operateEntityPackages) {
            this.operateEntityPackages = operateEntityPackages;
            return this;
        }

        public Properties setEnableMethodArgumentAutoOperate(boolean enableMethodArgumentAutoOperate) {
            this.enableMethodArgumentAutoOperate = enableMethodArgumentAutoOperate;
            return this;
        }

        public Properties setEnableMethodResultAutoOperate(boolean enableMethodResultAutoOperate) {
            this.enableMethodResultAutoOperate = enableMethodResultAutoOperate;
            return this;
        }

        public Properties setEnableMethodContainer(boolean enableMethodContainer) {
            this.enableMethodContainer = enableMethodContainer;
            return this;
        }

        public Properties setCacheContainers(Map<String, Set<String>> cacheContainers) {
            this.cacheContainers = cacheContainers;
            return this;
        }
    }
}

