/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.util;

import cn.hutool.core.util.ArrayUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.ParameterNameDiscoverer;

public class MethodUtils {
    public static Map<String, Parameter> resolveParameterNames(ParameterNameDiscoverer discoverer, Method method) {
        Object[] parameters = method.getParameters();
        String[] parameterNames = discoverer.getParameterNames(method);
        if (ArrayUtil.isEmpty((Object[])parameters)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>(parameters.length);
        int nameLength = ArrayUtil.length((Object)parameterNames);
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            String parameterName = nameLength < i ? ((Parameter)parameter).getName() : parameterNames[i];
            parameterMap.put(parameterName, (Parameter)parameter);
        }
        return parameterMap;
    }

    private MethodUtils() {
    }
}

