/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support.expression;

import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.springboot.support.expression.SpelExpressionContext;
import cn.hutool.core.map.MapUtil;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;

public class SpelExpressionEvaluator
implements ExpressionEvaluator,
DisposableBean {
    private final Map<String, Expression> expressionCaches = CollectionUtils.newWeakConcurrentMap();
    private final ExpressionParser expressionParser;

    public <T> @Nullable T execute(String expression, Class<T> resultType, ExpressionContext context) {
        Object evaluationContext = context instanceof SpelExpressionContext ? (EvaluationContext)context : new SpelExpressionContext(context);
        return (T)this.parseExpression(expression).getValue(evaluationContext, resultType);
    }

    public void destroy() {
        this.expressionCaches.clear();
    }

    private Expression parseExpression(String expression) {
        return (Expression)MapUtil.computeIfAbsent(this.expressionCaches, (Object)expression, arg_0 -> ((ExpressionParser)this.expressionParser).parseExpression(arg_0));
    }

    public SpelExpressionEvaluator(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }
}

