/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.springboot.support.aop;

import cn.crane4j.annotation.AutoOperate;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.springboot.support.MethodAnnotatedElementAutoOperateSupport;
import cn.crane4j.springboot.support.MethodBaseExpressionEvaluator;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.map.MapUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.annotation.AnnotatedElementUtils;

@Aspect
public class MethodResultAutoOperateAspect
extends MethodAnnotatedElementAutoOperateSupport
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MethodResultAutoOperateAspect.class);
    private final Map<String, MethodAnnotatedElementAutoOperateSupport.ResolvedElement> methodCaches = CollectionUtils.newWeakConcurrentMap();

    public MethodResultAutoOperateAspect(Crane4jGlobalConfiguration configuration, MethodBaseExpressionEvaluator methodBaseExpressionEvaluator) {
        super(configuration, methodBaseExpressionEvaluator);
        log.info("enable automatic filling of method result");
    }

    @AfterReturning(returning="result", pointcut="@annotation(cn.crane4j.annotation.AutoOperate)")
    public void afterReturning(JoinPoint joinPoint, Object result) {
        if (Objects.isNull(result)) {
            return;
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        AutoOperate annotation = (AutoOperate)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, AutoOperate.class);
        if (Objects.isNull(annotation)) {
            return;
        }
        String condition = annotation.condition();
        if (!this.checkSupport(joinPoint.getArgs(), result, method, condition)) {
            return;
        }
        log.debug("process result for [{}]", (Object)method.getName());
        MethodAnnotatedElementAutoOperateSupport.ResolvedElement element = (MethodAnnotatedElementAutoOperateSupport.ResolvedElement)MapUtil.computeIfAbsent(this.methodCaches, (Object)method.getName(), m -> this.resolveElement(method, annotation));
        try {
            element.execute(result);
        }
        catch (Exception e) {
            log.warn("cannot process result for [{}]: [{}]", (Object)method.getName(), (Object)ExceptionUtil.getRootCause((Throwable)e).getMessage());
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.methodCaches.clear();
    }
}

